/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.util.PreferenceManager;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLPreferenceManager
extends PreferenceManager {
    protected String xmlParserClassName;
    public static final String PREFERENCE_ENCODING = "8859_1";

    public XMLPreferenceManager(String string) {
        this(string, null, XMLResourceDescriptor.getXMLParserClassName());
    }

    public XMLPreferenceManager(String string, Map map) {
        this(string, map, XMLResourceDescriptor.getXMLParserClassName());
    }

    public XMLPreferenceManager(String string, String string2) {
        this(string, null, string2);
    }

    public XMLPreferenceManager(String string, Map map, String string2) {
        super(string, map);
        this.internal = new XMLProperties();
        this.xmlParserClassName = string2;
    }

    protected class XMLProperties
    extends Properties {
        protected XMLProperties() {
        }

        @Override
        public synchronized void load(InputStream inputStream) throws IOException {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, XMLPreferenceManager.PREFERENCE_ENCODING));
            SAXDocumentFactory sAXDocumentFactory = new SAXDocumentFactory(GenericDOMImplementation.getDOMImplementation(), XMLPreferenceManager.this.xmlParserClassName);
            Document document = sAXDocumentFactory.createDocument("http://xml.apache.org/batik/preferences", "preferences", null, bufferedReader);
            Element element = document.getDocumentElement();
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                Object object;
                if (node.getNodeType() != 1 || !node.getNodeName().equals("property")) continue;
                String string = ((Element)node).getAttributeNS(null, "name");
                StringBuffer stringBuffer = new StringBuffer();
                for (object = node.getFirstChild(); object != null && object.getNodeType() == 3; object = object.getNextSibling()) {
                    stringBuffer.append(object.getNodeValue());
                }
                object = stringBuffer.toString();
                this.put(string, object);
            }
        }

        @Override
        public synchronized void store(OutputStream outputStream, String string) throws IOException {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, XMLPreferenceManager.PREFERENCE_ENCODING));
            HashMap hashMap = new HashMap();
            this.enumerate(hashMap);
            bufferedWriter.write("<preferences xmlns=\"http://xml.apache.org/batik/preferences\">\n");
            for (String string2 : hashMap.keySet()) {
                String string3 = (String)hashMap.get(string2);
                bufferedWriter.write("<property name=\"" + string2 + "\">");
                bufferedWriter.write(DOMUtilities.contentToString(string3));
                bufferedWriter.write("</property>\n");
            }
            bufferedWriter.write("</preferences>\n");
            bufferedWriter.flush();
        }

        private synchronized void enumerate(Map map) {
            if (this.defaults != null) {
                for (Object object : map.keySet()) {
                    map.put(object, this.defaults.get(object));
                }
            }
            for (Object object : this.keySet()) {
                map.put(object, this.get(object));
            }
        }
    }
}

