/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.BuildNumber;
import java.awt.Rectangle;
import java.util.Calendar;

public abstract class ApplicationInfo {
    public abstract Calendar getBuildDate();

    public abstract BuildNumber getBuild();

    public abstract String getApiVersion();

    public abstract String getMajorVersion();

    public abstract String getMinorVersion();

    public abstract String getMicroVersion();

    public abstract String getPatchVersion();

    public abstract String getVersionName();

    public abstract String getHelpURL();

    public abstract String getCompanyName();

    public abstract String getCompanyURL();

    public abstract String getThirdPartySoftwareURL();

    public abstract String getJetbrainsTvUrl();

    public abstract String getEvalLicenseUrl();

    public abstract String getKeyConversionUrl();

    public abstract Rectangle getAboutLogoRect();

    public abstract boolean hasHelp();

    public abstract boolean hasContextHelp();

    public abstract String getFullVersion();

    public abstract String getStrictVersion();

    public static ApplicationInfo getInstance() {
        return ServiceManager.getService(ApplicationInfo.class);
    }

    public static boolean helpAvailable() {
        return ApplicationManager.getApplication() != null && ApplicationInfo.getInstance() != null && ApplicationInfo.getInstance().hasHelp();
    }

    public static boolean contextHelpAvailable() {
        return ApplicationManager.getApplication() != null && ApplicationInfo.getInstance() != null && ApplicationInfo.getInstance().hasContextHelp();
    }

    public String getBuildNumber() {
        return this.getBuild().asString();
    }
}

