/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.util.Comparing;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;

public abstract class KeyedExtensionFactory<T, KeyT> {
    private final Class<T> myInterfaceClass;
    private final ExtensionPointName<KeyedFactoryEPBean> myEpName;
    private final PicoContainer myPicoContainer;

    public KeyedExtensionFactory(@NotNull Class<T> interfaceClass, @NonNls @NotNull ExtensionPointName<KeyedFactoryEPBean> epName, @NotNull PicoContainer picoContainer) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceClass", "com/intellij/openapi/util/KeyedExtensionFactory", "<init>"));
        }
        if (epName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "epName", "com/intellij/openapi/util/KeyedExtensionFactory", "<init>"));
        }
        if (picoContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "picoContainer", "com/intellij/openapi/util/KeyedExtensionFactory", "<init>"));
        }
        this.myInterfaceClass = interfaceClass;
        this.myEpName = epName;
        this.myPicoContainer = picoContainer;
    }

    @NotNull
    public T get() {
        final KeyedFactoryEPBean[] epBeans = Extensions.getExtensions(this.myEpName);
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object keyArg = args[0];
                String key = KeyedExtensionFactory.this.getKey(keyArg);
                Object result = KeyedExtensionFactory.this.getByKey(epBeans, key, method, args);
                if (result == null) {
                    result = KeyedExtensionFactory.this.getByKey(epBeans, null, method, args);
                }
                return result;
            }
        };
        Object object = Proxy.newProxyInstance(this.myInterfaceClass.getClassLoader(), new Class[]{this.myInterfaceClass}, handler);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/KeyedExtensionFactory", "get"));
        }
        return (T)object;
    }

    public T getByKey(@NotNull KeyT key) {
        KeyedFactoryEPBean[] epBeans;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/KeyedExtensionFactory", "getByKey"));
        }
        for (KeyedFactoryEPBean epBean : epBeans = Extensions.getExtensions(this.myEpName)) {
            if (!Comparing.strEqual(this.getKey(key), epBean.key)) continue;
            try {
                if (epBean.implementationClass == null) continue;
                return epBean.instantiate(epBean.implementationClass, this.myPicoContainer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private T getByKey(KeyedFactoryEPBean[] epBeans, String key, Method method, Object[] args) {
        Object result = null;
        for (KeyedFactoryEPBean epBean : epBeans) {
            if (!Comparing.strEqual(epBean.key, key, true)) continue;
            try {
                if (epBean.implementationClass != null) {
                    result = epBean.instantiate(epBean.implementationClass, this.myPicoContainer);
                } else {
                    Object factory = epBean.instantiate(epBean.factoryClass, this.myPicoContainer);
                    result = method.invoke(factory, args);
                }
                if (result == null) continue;
                break;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (T)result;
    }

    public abstract String getKey(@NotNull KeyT var1);
}

