/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeElementPattern<ParentType, T extends ParentType, Self extends TreeElementPattern<ParentType, T, Self>>
extends ObjectPattern<T, Self> {
    protected TreeElementPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/TreeElementPattern", "<init>"));
        }
        super(condition);
    }

    protected TreeElementPattern(Class<T> aClass) {
        super(aClass);
    }

    @Nullable
    protected abstract ParentType getParent(@NotNull ParentType var1);

    protected abstract ParentType[] getChildren(@NotNull ParentType var1);

    public Self withParents(final Class<? extends ParentType> ... types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/patterns/TreeElementPattern", "withParents"));
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("withParents"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/TreeElementPattern$1", "accepts"));
                }
                Object current = TreeElementPattern.this.getParent(t);
                for (Class type : types) {
                    if (current == null || !type.isInstance(current)) {
                        return false;
                    }
                    current = TreeElementPattern.this.getParent(current);
                }
                return true;
            }
        }));
    }

    public Self withParent(@NotNull Class<? extends ParentType> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/patterns/TreeElementPattern", "withParent"));
        }
        return this.withParent(StandardPatterns.instanceOf(type));
    }

    public Self withParent(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/TreeElementPattern", "withParent"));
        }
        return this.withSuperParent(1, pattern);
    }

    public Self withChild(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/TreeElementPattern", "withChild"));
        }
        return this.withChildren(StandardPatterns.collection().atLeastOne(pattern));
    }

    public Self withFirstChild(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/TreeElementPattern", "withFirstChild"));
        }
        return this.withChildren(StandardPatterns.collection().first(pattern));
    }

    public Self withLastChild(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/TreeElementPattern", "withLastChild"));
        }
        return this.withChildren(StandardPatterns.collection().last(pattern));
    }

    public Self withChildren(@NotNull ElementPattern<Collection<ParentType>> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/TreeElementPattern", "withChildren"));
        }
        return (Self)((TreeElementPattern)this.with(new PatternConditionPlus<T, Collection<ParentType>>("withChildren", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<Collection<ParentType>, ProcessingContext> processor) {
                return processor.process(Arrays.asList(TreeElementPattern.this.getChildren(t)), context);
            }
        }));
    }

    public Self isFirstAcceptedChild(final @NotNull ElementPattern<? super ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/TreeElementPattern", "isFirstAcceptedChild"));
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("isFirstAcceptedChild"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/TreeElementPattern$3", "accepts"));
                }
                Object parent = TreeElementPattern.this.getParent(t);
                if (parent != null) {
                    T[] children;
                    for (Object child : children = TreeElementPattern.this.getChildren(parent)) {
                        if (!pattern.accepts(child, context)) continue;
                        return child == t;
                    }
                }
                return false;
            }
        }));
    }

    public Self withSuperParent(int level, @NotNull Class<? extends ParentType> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/patterns/TreeElementPattern", "withSuperParent"));
        }
        return this.withSuperParent(level, StandardPatterns.instanceOf(aClass));
    }

    public Self withSuperParent(final int level, @NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/TreeElementPattern", "withSuperParent"));
        }
        return (Self)((TreeElementPattern)this.with(new PatternConditionPlus<T, ParentType>(level == 1 ? "withParent" : "withSuperParent", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<ParentType, ProcessingContext> processor) {
                Object parent = t;
                for (int i = 0; i < level; ++i) {
                    if (parent == null) {
                        return true;
                    }
                    parent = TreeElementPattern.this.getParent(parent);
                }
                return processor.process(parent, context);
            }
        }));
    }

    public Self inside(@NotNull Class<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/TreeElementPattern", "inside"));
        }
        return this.inside(StandardPatterns.instanceOf(pattern));
    }

    public Self inside(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/TreeElementPattern", "inside"));
        }
        return this.inside(false, pattern);
    }

    public Self inside(final boolean strict, @NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/TreeElementPattern", "inside"));
        }
        return (Self)((TreeElementPattern)this.with(new PatternConditionPlus<T, ParentType>("inside", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<ParentType, ProcessingContext> processor) {
                Object element;
                Object t2 = element = strict ? TreeElementPattern.this.getParent(t) : t;
                while (element != null) {
                    if (!processor.process(element, context)) {
                        return false;
                    }
                    element = TreeElementPattern.this.getParent(element);
                }
                return true;
            }
        }));
    }

    public Self withAncestor(final int levelsUp, final @NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/TreeElementPattern", "withAncestor"));
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("withAncestor"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/TreeElementPattern$6", "accepts"));
                }
                Object element = t;
                for (int i = 0; i < levelsUp + 1; ++i) {
                    if (pattern.accepts(element, context)) {
                        return true;
                    }
                    if ((element = TreeElementPattern.this.getParent(element)) == null) break;
                }
                return false;
            }
        }));
    }

    public Self inside(final boolean strict, final @NotNull ElementPattern<? extends ParentType> pattern, final @NotNull ElementPattern<? extends ParentType> stopAt) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/TreeElementPattern", "inside"));
        }
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/intellij/patterns/TreeElementPattern", "inside"));
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("inside"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                Object element;
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/TreeElementPattern$7", "accepts"));
                }
                Object t2 = element = strict ? TreeElementPattern.this.getParent(t) : t;
                while (element != null) {
                    if (stopAt.accepts(element, context)) {
                        return false;
                    }
                    if (pattern.accepts(element, context)) {
                        return true;
                    }
                    element = TreeElementPattern.this.getParent(element);
                }
                return false;
            }
        }));
    }

    public Self insideSequence(final boolean strict, final ElementPattern<? extends ParentType> ... patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/patterns/TreeElementPattern", "insideSequence"));
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("insideSequence"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                Object element;
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/TreeElementPattern$8", "accepts"));
                }
                int i = 0;
                Object t2 = element = strict ? TreeElementPattern.this.getParent(t) : t;
                while (element != null && i < patterns.length) {
                    for (int j = i; j < patterns.length; ++j) {
                        if (!patterns[j].accepts(element, context)) continue;
                        if (i != j) {
                            return false;
                        }
                        ++i;
                        break;
                    }
                    element = TreeElementPattern.this.getParent(element);
                }
                return true;
            }
        }));
    }

    public Self afterSibling(final ElementPattern<? extends ParentType> pattern) {
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("afterSibling"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/TreeElementPattern$9", "accepts"));
                }
                Object parent = TreeElementPattern.this.getParent(t);
                if (parent == null) {
                    return false;
                }
                T[] children = TreeElementPattern.this.getChildren(parent);
                int i = Arrays.asList(children).indexOf(t);
                if (i <= 0) {
                    return false;
                }
                return pattern.accepts(children[i - 1], context);
            }
        }));
    }

    public Self afterSiblingSkipping(final @NotNull ElementPattern skip, final ElementPattern<? extends ParentType> pattern) {
        if (skip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skip", "com/intellij/patterns/TreeElementPattern", "afterSiblingSkipping"));
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("afterSiblingSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/TreeElementPattern$10", "accepts"));
                }
                Object parent = TreeElementPattern.this.getParent(t);
                if (parent == null) {
                    return false;
                }
                T[] children = TreeElementPattern.this.getChildren(parent);
                int i = Arrays.asList(children).indexOf(t);
                while (--i >= 0) {
                    if (skip.accepts(children[i], context)) continue;
                    return pattern.accepts(children[i], context);
                }
                return false;
            }
        }));
    }
}

