/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Iterator;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyntaxTraverser<T>
extends FilteredTraverserBase<T, SyntaxTraverser<T>>
implements UserDataHolder {
    public final Api<T> api;

    @NotNull
    public static ApiEx<PsiElement> psiApi() {
        ApiEx<PsiElement> apiEx = PsiApi.INSTANCE;
        if (apiEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "psiApi"));
        }
        return apiEx;
    }

    @NotNull
    public static ApiEx<PsiElement> psiApiReversed() {
        ApiEx<PsiElement> apiEx = PsiApi.INSTANCE_REV;
        if (apiEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "psiApiReversed"));
        }
        return apiEx;
    }

    @NotNull
    public static ApiEx<ASTNode> astApi() {
        ASTApi aSTApi = ASTApi.INSTANCE;
        if (aSTApi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "astApi"));
        }
        return aSTApi;
    }

    @NotNull
    public static Api<LighterASTNode> lightApi(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/psi/SyntaxTraverser", "lightApi"));
        }
        LighterASTApi lighterASTApi = new LighterASTApi(builder);
        if (lighterASTApi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "lightApi"));
        }
        return lighterASTApi;
    }

    @NotNull
    public static <T> SyntaxTraverser<T> syntaxTraverser(@NotNull Api<T> api) {
        if (api == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "api", "com/intellij/psi/SyntaxTraverser", "syntaxTraverser"));
        }
        SyntaxTraverser<T> syntaxTraverser = new SyntaxTraverser<T>(api, null);
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "syntaxTraverser"));
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> psiTraverser() {
        SyntaxTraverser<PsiElement> syntaxTraverser = new SyntaxTraverser<PsiElement>(SyntaxTraverser.psiApi(), null);
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "psiTraverser"));
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> psiTraverser(@Nullable PsiElement root) {
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot(root);
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "psiTraverser"));
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> revPsiTraverser() {
        SyntaxTraverser<PsiElement> syntaxTraverser = new SyntaxTraverser<PsiElement>(SyntaxTraverser.psiApiReversed(), null);
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "revPsiTraverser"));
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<ASTNode> astTraverser() {
        SyntaxTraverser<ASTNode> syntaxTraverser = new SyntaxTraverser<ASTNode>(SyntaxTraverser.astApi(), null);
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "astTraverser"));
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<ASTNode> astTraverser(@Nullable ASTNode root) {
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SyntaxTraverser.astTraverser().withRoot(root);
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "astTraverser"));
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<LighterASTNode> lightTraverser(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/psi/SyntaxTraverser", "lightTraverser"));
        }
        LighterASTApi api = new LighterASTApi(builder);
        SyntaxTraverser<LighterASTNode> syntaxTraverser = new SyntaxTraverser<LighterASTNode>(api, FilteredTraverserBase.Meta.empty().withRoots(JBIterable.of(api.getStructure().getRoot())));
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "lightTraverser"));
        }
        return syntaxTraverser;
    }

    protected SyntaxTraverser(@NotNull Api<T> api, @Nullable FilteredTraverserBase.Meta<T> meta) {
        if (api == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "api", "com/intellij/psi/SyntaxTraverser", "<init>"));
        }
        super(meta, api);
        this.api = api;
    }

    @Override
    @NotNull
    protected SyntaxTraverser<T> newInstance(FilteredTraverserBase.Meta<T> meta) {
        SyntaxTraverser<T> syntaxTraverser = new SyntaxTraverser<T>(this.api, meta);
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "newInstance"));
        }
        return syntaxTraverser;
    }

    @Override
    protected boolean isAlwaysLeaf(@NotNull T node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser", "isAlwaysLeaf"));
        }
        return super.isAlwaysLeaf(node) && !(this.api.typeOf(node) instanceof IFileElementType);
    }

    @Nullable
    public <K> K getUserData(@NotNull Key<K> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/SyntaxTraverser", "getUserData"));
        }
        return this.getUserDataHolder().getUserData(key);
    }

    public <K> void putUserData(@NotNull Key<K> key, @Nullable K value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/SyntaxTraverser", "putUserData"));
        }
        this.getUserDataHolder().putUserData(key, value);
    }

    private UserDataHolder getUserDataHolder() {
        return this.api instanceof LighterASTApi ? ((LighterASTApi)this.api).builder : (UserDataHolder)this.api.parents(this.getRoot()).last();
    }

    @NotNull
    public SyntaxTraverser<T> expandTypes(@NotNull Condition<? super IElementType> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/psi/SyntaxTraverser", "expandTypes"));
        }
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)super.expand(Conditions.compose(this.api.TO_TYPE, c));
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "expandTypes"));
        }
        return syntaxTraverser;
    }

    @NotNull
    public SyntaxTraverser<T> filterTypes(@NotNull Condition<? super IElementType> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/psi/SyntaxTraverser", "filterTypes"));
        }
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)super.filter(Conditions.compose(this.api.TO_TYPE, c));
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "filterTypes"));
        }
        return syntaxTraverser;
    }

    @NotNull
    public SyntaxTraverser<T> forceDisregardTypes(@NotNull Condition<? super IElementType> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/psi/SyntaxTraverser", "forceDisregardTypes"));
        }
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)super.forceDisregard(Conditions.compose(this.api.TO_TYPE, c));
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "forceDisregardTypes"));
        }
        return syntaxTraverser;
    }

    @Nullable
    public T getRawDeepestLast() {
        Object result = JBIterable.from(this.getRoots()).last();
        while (result != null) {
            Object last;
            JBIterable children = this.children(result);
            if (children.isEmpty()) {
                return result;
            }
            result = last = children.last();
        }
        return null;
    }

    private static class LighterASTApi
    extends FlyweightApi<LighterASTNode> {
        private final PsiBuilder builder;
        private final ThreadLocalCachedValue<FlyweightCapableTreeStructure<LighterASTNode>> structure = new ThreadLocalCachedValue<FlyweightCapableTreeStructure<LighterASTNode>>(){

            @Override
            protected FlyweightCapableTreeStructure<LighterASTNode> create() {
                return LighterASTApi.this.builder.getLightTree();
            }
        };

        public LighterASTApi(PsiBuilder builder) {
            this.builder = builder;
        }

        @Override
        @NotNull
        FlyweightCapableTreeStructure<LighterASTNode> getStructure() {
            FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = this.structure.getValue();
            if (flyweightCapableTreeStructure == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$LighterASTApi", "getStructure"));
            }
            return flyweightCapableTreeStructure;
        }

        @Override
        @NotNull
        public IElementType typeOf(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$LighterASTApi", "typeOf"));
            }
            IElementType iElementType = node.getTokenType();
            if (iElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$LighterASTApi", "typeOf"));
            }
            return iElementType;
        }

        @Override
        @NotNull
        public TextRange rangeOf(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$LighterASTApi", "rangeOf"));
            }
            TextRange textRange = TextRange.create(node.getStartOffset(), node.getEndOffset());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$LighterASTApi", "rangeOf"));
            }
            return textRange;
        }

        @Override
        @NotNull
        public CharSequence textOf(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$LighterASTApi", "textOf"));
            }
            CharSequence charSequence = this.rangeOf(node).subSequence(this.builder.getOriginalText());
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$LighterASTApi", "textOf"));
            }
            return charSequence;
        }

        @Override
        @Nullable
        public LighterASTNode parent(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$LighterASTApi", "parent"));
            }
            return node instanceof LighterASTTokenNode ? null : super.parent(node);
        }
    }

    private static abstract class FlyweightApi<T>
    extends Api<T> {
        private FlyweightApi() {
        }

        @NotNull
        abstract FlyweightCapableTreeStructure<T> getStructure();

        @Override
        @Nullable
        public T parent(@NotNull T node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$FlyweightApi", "parent"));
            }
            return this.getStructure().getParent(node);
        }

        @Override
        @NotNull
        public JBIterable<? extends T> children(final @NotNull T node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$FlyweightApi", "children"));
            }
            JBIterable jBIterable = new JBIterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    FlyweightCapableTreeStructure<Object> structure = FlyweightApi.this.getStructure();
                    Ref<T[]> ref = Ref.create();
                    int count = structure.getChildren(structure.prepareForGetChildren(node), ref);
                    if (count == 0) {
                        return ContainerUtil.emptyIterator();
                    }
                    T[] array = ref.get();
                    LinkedList list = ContainerUtil.newLinkedList();
                    for (int i = 0; i < count; ++i) {
                        Object child = array[i];
                        IElementType childType = FlyweightApi.this.typeOf(child);
                        if (childType == TokenType.WHITE_SPACE || childType == TokenType.BAD_CHARACTER) continue;
                        array[i] = null;
                        list.addLast(child);
                    }
                    structure.disposeChildren(array, count);
                    return list.iterator();
                }
            };
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$FlyweightApi", "children"));
            }
            return jBIterable;
        }
    }

    private static class ASTApi
    extends ApiEx<ASTNode> {
        static final ASTApi INSTANCE = new ASTApi();

        private ASTApi() {
        }

        @Override
        @Nullable
        public ASTNode first(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ASTApi", "first"));
            }
            return node.getFirstChildNode();
        }

        @Override
        @Nullable
        public ASTNode last(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ASTApi", "last"));
            }
            return node.getLastChildNode();
        }

        @Override
        @Nullable
        public ASTNode next(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ASTApi", "next"));
            }
            return node.getTreeNext();
        }

        @Override
        @Nullable
        public ASTNode previous(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ASTApi", "previous"));
            }
            return node.getTreePrev();
        }

        @Override
        @NotNull
        public IElementType typeOf(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ASTApi", "typeOf"));
            }
            IElementType iElementType = node.getElementType();
            if (iElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$ASTApi", "typeOf"));
            }
            return iElementType;
        }

        @Override
        @NotNull
        public TextRange rangeOf(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ASTApi", "rangeOf"));
            }
            TextRange textRange = node.getTextRange();
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$ASTApi", "rangeOf"));
            }
            return textRange;
        }

        @Override
        @NotNull
        public CharSequence textOf(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ASTApi", "textOf"));
            }
            String string = node.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$ASTApi", "textOf"));
            }
            return string;
        }

        @Override
        @Nullable
        public ASTNode parent(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ASTApi", "parent"));
            }
            return node.getTreeParent();
        }
    }

    private static class PsiApi
    extends ApiEx<PsiElement> {
        static final ApiEx<PsiElement> INSTANCE = new PsiApi();
        static final ApiEx<PsiElement> INSTANCE_REV = new PsiApi(){

            @Override
            @Nullable
            public PsiElement previous(@NotNull PsiElement node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiApi$1", "previous"));
                }
                return super.next(node);
            }

            @Override
            @Nullable
            public PsiElement next(@NotNull PsiElement node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiApi$1", "next"));
                }
                return super.previous(node);
            }

            @Override
            @Nullable
            public PsiElement last(@NotNull PsiElement node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiApi$1", "last"));
                }
                return super.first(node);
            }

            @Override
            @Nullable
            public PsiElement first(@NotNull PsiElement node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiApi$1", "first"));
                }
                return super.last(node);
            }
        };

        private PsiApi() {
        }

        @Override
        @Nullable
        public PsiElement first(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiApi", "first"));
            }
            return node.getFirstChild();
        }

        @Override
        @Nullable
        public PsiElement last(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiApi", "last"));
            }
            return node.getLastChild();
        }

        @Override
        @Nullable
        public PsiElement next(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiApi", "next"));
            }
            return node.getNextSibling();
        }

        @Override
        @Nullable
        public PsiElement previous(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiApi", "previous"));
            }
            return node.getPrevSibling();
        }

        @Override
        @NotNull
        public IElementType typeOf(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiApi", "typeOf"));
            }
            IElementType type = PsiUtilCore.getElementType(node);
            IElementType iElementType = type != null ? type : IElementType.find((short)0);
            if (iElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$PsiApi", "typeOf"));
            }
            return iElementType;
        }

        @Override
        @NotNull
        public TextRange rangeOf(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiApi", "rangeOf"));
            }
            TextRange textRange = node.getTextRange();
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$PsiApi", "rangeOf"));
            }
            return textRange;
        }

        @Override
        @NotNull
        public CharSequence textOf(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiApi", "textOf"));
            }
            String string = node.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$PsiApi", "textOf"));
            }
            return string;
        }

        @Override
        @Nullable
        public PsiElement parent(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiApi", "parent"));
            }
            return node instanceof PsiFile ? null : node.getParent();
        }
    }

    public static abstract class ApiEx<T>
    extends Api<T> {
        private final Function<T, T> TO_NEXT = new Function<T, T>(){

            @Override
            public T fun(T t) {
                return ApiEx.this.next(t);
            }

            public String toString() {
                return "TO_NEXT";
            }
        };

        @Nullable
        public abstract T first(@NotNull T var1);

        @Nullable
        public abstract T last(@NotNull T var1);

        @Nullable
        public abstract T next(@NotNull T var1);

        @Nullable
        public abstract T previous(@NotNull T var1);

        @Override
        @NotNull
        public JBIterable<? extends T> children(@NotNull T node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ApiEx", "children"));
            }
            T first = this.first(node);
            if (first == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$ApiEx", "children"));
                }
                return jBIterable;
            }
            JBIterable<T> jBIterable = JBIterable.generate(first, this.TO_NEXT);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$ApiEx", "children"));
            }
            return jBIterable;
        }
    }

    public static abstract class Api<T>
    implements Function<T, Iterable<? extends T>> {
        public final Function<T, IElementType> TO_TYPE = new Function<T, IElementType>(){

            @Override
            public IElementType fun(T t) {
                return Api.this.typeOf(t);
            }

            public String toString() {
                return "TO_TYPE";
            }
        };
        public final Function<T, CharSequence> TO_TEXT = new Function<T, CharSequence>(){

            @Override
            public CharSequence fun(T t) {
                return Api.this.textOf(t);
            }

            public String toString() {
                return "TO_TEXT";
            }
        };
        public final Function<T, TextRange> TO_RANGE = new Function<T, TextRange>(){

            @Override
            public TextRange fun(T t) {
                return Api.this.rangeOf(t);
            }

            public String toString() {
                return "TO_RANGE";
            }
        };

        @NotNull
        public abstract IElementType typeOf(@NotNull T var1);

        @NotNull
        public abstract TextRange rangeOf(@NotNull T var1);

        @NotNull
        public abstract CharSequence textOf(@NotNull T var1);

        @Nullable
        public abstract T parent(@NotNull T var1);

        @NotNull
        public abstract JBIterable<? extends T> children(@NotNull T var1);

        @Override
        public JBIterable<? extends T> fun(T t) {
            return this.children(t);
        }

        @NotNull
        public JBIterable<T> parents(@Nullable T element) {
            JBIterable<T> jBIterable = JBIterable.generate(element, new Function<T, T>(){

                @Override
                public T fun(T t) {
                    return Api.this.parent(t);
                }
            });
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$Api", "parents"));
            }
            return jBIterable;
        }
    }
}

