/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentRefValueIntObjectHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;

class ConcurrentSoftValueIntObjectHashMap<V>
extends ConcurrentRefValueIntObjectHashMap<V> {
    ConcurrentSoftValueIntObjectHashMap() {
    }

    @Override
    @NotNull
    protected ConcurrentRefValueIntObjectHashMap.IntReference<V> createReference(int key, @NotNull V value, @NotNull ReferenceQueue<V> queue) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentSoftValueIntObjectHashMap", "createReference"));
        }
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/util/containers/ConcurrentSoftValueIntObjectHashMap", "createReference"));
        }
        MyRef myRef = new MyRef(key, value, queue);
        if (myRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentSoftValueIntObjectHashMap", "createReference"));
        }
        return myRef;
    }

    private static class MyRef<V>
    extends SoftReference<V>
    implements ConcurrentRefValueIntObjectHashMap.IntReference<V> {
        private final int hash;
        private final int key;

        private MyRef(int key, @NotNull V referent, @NotNull ReferenceQueue<V> queue) {
            if (referent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/intellij/util/containers/ConcurrentSoftValueIntObjectHashMap$MyRef", "<init>"));
            }
            if (queue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/util/containers/ConcurrentSoftValueIntObjectHashMap$MyRef", "<init>"));
            }
            super(referent, queue);
            this.key = key;
            this.hash = referent.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            Object v = this.get();
            if (!(obj instanceof MyRef)) {
                return false;
            }
            MyRef other = (MyRef)obj;
            return other.hash == this.hash && this.key == other.getKey() && Comparing.equal(v, other.get());
        }

        @Override
        public int getKey() {
            return this.key;
        }
    }
}

