/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.Getter;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class PromiseManager<HOST, VALUE> {
    private final AtomicFieldUpdater<HOST, Promise<VALUE>> fieldUpdater;

    public PromiseManager(@NotNull AtomicFieldUpdater<HOST, Promise<VALUE>> fieldUpdater) {
        if (fieldUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldUpdater", "org/jetbrains/concurrency/PromiseManager", "<init>"));
        }
        this.fieldUpdater = fieldUpdater;
    }

    public PromiseManager(@NotNull Class<HOST> ownerClass) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "org/jetbrains/concurrency/PromiseManager", "<init>"));
        }
        this.fieldUpdater = AtomicFieldUpdater.forFieldOfType(ownerClass, Promise.class);
    }

    public boolean isUpToDate(@NotNull HOST host, @NotNull VALUE value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/concurrency/PromiseManager", "isUpToDate"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/concurrency/PromiseManager", "isUpToDate"));
        }
        return true;
    }

    @NotNull
    public abstract Promise<VALUE> load(@NotNull HOST var1);

    public final void reset(HOST host) {
        this.fieldUpdater.set(host, null);
    }

    public final void set(HOST host, @Nullable VALUE value) {
        if (value == null) {
            this.reset(host);
        } else {
            ((AsyncPromise)this.getOrCreateAsyncResult(host, false, false)).setResult(value);
        }
    }

    public final boolean has(HOST host) {
        Promise<VALUE> result = this.fieldUpdater.get(host);
        return result != null && result.getState() == Promise.State.FULFILLED;
    }

    @Nullable
    public final Promise.State getState(HOST host) {
        Promise<VALUE> result = this.fieldUpdater.get(host);
        return result == null ? null : result.getState();
    }

    @NotNull
    public final Promise<VALUE> get(HOST host) {
        Promise<VALUE> promise = this.get(host, true);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "get"));
        }
        return promise;
    }

    @NotNull
    public final Promise<VALUE> get(HOST host, boolean checkFreshness) {
        Promise<VALUE> promise = this.getOrCreateAsyncResult(host, checkFreshness, true);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "get"));
        }
        return promise;
    }

    @NotNull
    private Promise<VALUE> getOrCreateAsyncResult(HOST host, boolean checkFreshness, boolean load) {
        Promise<VALUE> promise = this.fieldUpdater.get(host);
        if (promise == null) {
            promise = new AsyncPromise<VALUE>();
            if (!this.fieldUpdater.compareAndSet(host, null, promise)) {
                Promise<VALUE> promise2 = this.fieldUpdater.get(host);
                if (promise2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getOrCreateAsyncResult"));
                }
                return promise2;
            }
        } else {
            Promise.State state = promise.getState();
            if (state == Promise.State.PENDING) {
                Promise<VALUE> promise3 = promise;
                if (promise3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getOrCreateAsyncResult"));
                }
                return promise3;
            }
            if (state == Promise.State.FULFILLED) {
                if (!checkFreshness || this.isUpToDate(host, ((Getter)((Object)promise)).get())) {
                    Promise<VALUE> promise4 = promise;
                    if (promise4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getOrCreateAsyncResult"));
                    }
                    return promise4;
                }
                if (!this.fieldUpdater.compareAndSet(host, promise, promise = new AsyncPromise<VALUE>())) {
                    Promise<VALUE> valueFromAnotherThread = this.fieldUpdater.get(host);
                    while (valueFromAnotherThread == null) {
                        if (this.fieldUpdater.compareAndSet(host, null, promise)) {
                            Promise<VALUE> promise5 = this.getPromise(host, load, promise);
                            if (promise5 == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getOrCreateAsyncResult"));
                            }
                            return promise5;
                        }
                        valueFromAnotherThread = this.fieldUpdater.get(host);
                    }
                    Promise<VALUE> promise6 = valueFromAnotherThread;
                    if (promise6 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getOrCreateAsyncResult"));
                    }
                    return promise6;
                }
            }
        }
        Promise<VALUE> promise7 = this.getPromise(host, load, promise);
        if (promise7 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getOrCreateAsyncResult"));
        }
        return promise7;
    }

    @NotNull
    private Promise<VALUE> getPromise(HOST host, boolean load, Promise<VALUE> promise) {
        if (!load || promise.getState() != Promise.State.PENDING) {
            Promise<VALUE> promise2 = promise;
            if (promise2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getPromise"));
            }
            return promise2;
        }
        Promise<VALUE> effectivePromise = this.load(host);
        if (effectivePromise != promise) {
            this.fieldUpdater.compareAndSet(host, promise, effectivePromise);
            effectivePromise.notify((AsyncPromise)promise);
        }
        Promise<VALUE> promise3 = effectivePromise;
        if (promise3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getPromise"));
        }
        return promise3;
    }
}

