/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class JavaAnalysisScope
extends AnalysisScope {
    public static final int PACKAGE = 5;

    public JavaAnalysisScope(PsiPackage pack, Module module) {
        super(pack.getProject());
        this.myModule = module;
        this.myElement = pack;
        this.myType = 5;
    }

    public JavaAnalysisScope(PsiJavaFile psiFile) {
        super(psiFile);
    }

    @Override
    @NotNull
    public AnalysisScope getNarrowedComplementaryScope(@NotNull Project defaultProject) {
        if (defaultProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultProject", "com/intellij/analysis/JavaAnalysisScope", "getNarrowedComplementaryScope"));
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(defaultProject).getFileIndex();
        HashSet<Module> modules = new HashSet<Module>();
        if (this.myType == 3) {
            if (this.myElement instanceof PsiJavaFile && !FileTypeUtils.isInServerPageFile(this.myElement)) {
                PsiDirectory psiDirectory;
                PsiJavaFile psiJavaFile = (PsiJavaFile)this.myElement;
                PsiClass[] classes = psiJavaFile.getClasses();
                boolean onlyPackLocalClasses = true;
                for (PsiClass aClass : classes) {
                    if (!aClass.hasModifierProperty("public")) continue;
                    onlyPackLocalClasses = false;
                }
                if (onlyPackLocalClasses && (psiDirectory = psiJavaFile.getContainingDirectory()) != null) {
                    JavaAnalysisScope javaAnalysisScope = new JavaAnalysisScope(JavaDirectoryService.getInstance().getPackage(psiDirectory), null);
                    if (javaAnalysisScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/JavaAnalysisScope", "getNarrowedComplementaryScope"));
                    }
                    return javaAnalysisScope;
                }
            }
        } else if (this.myType == 5) {
            PsiDirectory[] directories;
            for (PsiDirectory directory : directories = ((PsiPackage)this.myElement).getDirectories()) {
                modules.addAll(JavaAnalysisScope.getAllInterestingModules(fileIndex, directory.getVirtualFile()));
            }
            AnalysisScope analysisScope = JavaAnalysisScope.collectScopes(defaultProject, modules);
            if (analysisScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/JavaAnalysisScope", "getNarrowedComplementaryScope"));
            }
            return analysisScope;
        }
        AnalysisScope analysisScope = super.getNarrowedComplementaryScope(defaultProject);
        if (analysisScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/JavaAnalysisScope", "getNarrowedComplementaryScope"));
        }
        return analysisScope;
    }

    @Override
    @NotNull
    public String getShortenName() {
        if (this.myType == 5) {
            String string = AnalysisScopeBundle.message("scope.package", ((PsiPackage)this.myElement).getQualifiedName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/JavaAnalysisScope", "getShortenName"));
            }
            return string;
        }
        String string = super.getShortenName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/JavaAnalysisScope", "getShortenName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if (this.myType == 5) {
            String string = AnalysisScopeBundle.message("scope.package", ((PsiPackage)this.myElement).getQualifiedName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/JavaAnalysisScope", "getDisplayName"));
            }
            return string;
        }
        String string = super.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/JavaAnalysisScope", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected void initFilesSet() {
        if (this.myType == 5) {
            this.myFilesSet = new HashSet();
            this.accept(this.createFileSearcher());
            return;
        }
        super.initFilesSet();
    }

    @Override
    public boolean accept(@NotNull Processor<VirtualFile> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/analysis/JavaAnalysisScope", "accept"));
        }
        if (this.myElement instanceof PsiPackage) {
            PsiPackage pack = (PsiPackage)this.myElement;
            HashSet dirs = new HashSet();
            ApplicationManager.getApplication().runReadAction(() -> ContainerUtil.addAll(dirs, pack.getDirectories(GlobalSearchScope.projectScope(this.myElement.getProject()))));
            for (PsiDirectory dir : dirs) {
                if (this.accept(dir, processor)) continue;
                return false;
            }
            return true;
        }
        return super.accept(processor);
    }

    @Override
    @NotNull
    public SearchScope toSearchScope() {
        if (this.myType == 5) {
            PackageScope packageScope = new PackageScope((PsiPackage)this.myElement, true, true);
            if (packageScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/JavaAnalysisScope", "toSearchScope"));
            }
            return packageScope;
        }
        SearchScope searchScope = super.toSearchScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/JavaAnalysisScope", "toSearchScope"));
        }
        return searchScope;
    }
}

