/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.TypeAnnotationModifier;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullityAnnotationModifier
extends TypeAnnotationModifier {
    @Override
    @Nullable
    public TypeAnnotationProvider modifyAnnotations(@NotNull PsiType inferenceVariableType, @NotNull PsiClassType boundType) {
        PsiAnnotation[] annotations;
        if (inferenceVariableType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inferenceVariableType", "com/intellij/codeInsight/NullityAnnotationModifier", "modifyAnnotations"));
        }
        if (boundType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boundType", "com/intellij/codeInsight/NullityAnnotationModifier", "modifyAnnotations"));
        }
        for (PsiAnnotation annotation : annotations = inferenceVariableType.getAnnotations()) {
            String qName = annotation.getQualifiedName();
            if (qName == null || !NullityAnnotationModifier.isMatchingAnnotation(boundType, annotation, qName)) continue;
            return NullityAnnotationModifier.removeAnnotation(annotations, annotation);
        }
        return null;
    }

    @NotNull
    private static TypeAnnotationProvider removeAnnotation(PsiAnnotation[] annotations, PsiAnnotation annotation) {
        ArrayList<PsiAnnotation> list = ContainerUtil.newArrayList(annotations);
        list.remove(annotation);
        if (list.isEmpty()) {
            TypeAnnotationProvider typeAnnotationProvider = TypeAnnotationProvider.EMPTY;
            if (typeAnnotationProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/NullityAnnotationModifier", "removeAnnotation"));
            }
            return typeAnnotationProvider;
        }
        PsiAnnotation[] array = list.toArray(PsiAnnotation.EMPTY_ARRAY);
        TypeAnnotationProvider typeAnnotationProvider = () -> array;
        if (typeAnnotationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/NullityAnnotationModifier", "removeAnnotation"));
        }
        return typeAnnotationProvider;
    }

    private static boolean isMatchingAnnotation(@NotNull PsiClassType boundType, PsiAnnotation annotation, String qName) {
        if (boundType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boundType", "com/intellij/codeInsight/NullityAnnotationModifier", "isMatchingAnnotation"));
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance(annotation.getProject());
        return (manager.getNullables().contains(qName) || manager.getNotNulls().contains(qName)) && boundType.findAnnotation(qName) != null;
    }
}

