/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.ThreadLocalAnnotatorMap;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedAnnotators {
    private final ThreadLocalAnnotatorMap<String, Annotator> cachedAnnotators = new ThreadLocalAnnotatorMap<String, Annotator>(){

        @Override
        @NotNull
        public Collection<Annotator> initialValue(@NotNull String languageId) {
            if (languageId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageId", "com/intellij/codeInsight/daemon/impl/CachedAnnotators$1", "initialValue"));
            }
            Language language = Language.findLanguageByID(languageId);
            List<Annotator> list = language == null ? ContainerUtil.emptyList() : LanguageAnnotators.INSTANCE.allForLanguage(language);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/CachedAnnotators$1", "initialValue"));
            }
            return list;
        }
    };

    public CachedAnnotators(Project project) {
        ExtensionPointListener<Annotator> listener = new ExtensionPointListener<Annotator>(){

            @Override
            public void extensionAdded(@NotNull Annotator extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInsight/daemon/impl/CachedAnnotators$2", "extensionAdded"));
                }
                CachedAnnotators.this.cachedAnnotators.clear();
            }

            @Override
            public void extensionRemoved(@NotNull Annotator extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInsight/daemon/impl/CachedAnnotators$2", "extensionRemoved"));
                }
                CachedAnnotators.this.cachedAnnotators.clear();
            }
        };
        LanguageAnnotators.INSTANCE.addListener(listener, project);
    }

    @NotNull
    List<Annotator> get(@NotNull String languageId) {
        if (languageId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageId", "com/intellij/codeInsight/daemon/impl/CachedAnnotators", "get"));
        }
        List<Annotator> list = this.cachedAnnotators.get(languageId);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/CachedAnnotators", "get"));
        }
        return list;
    }
}

