/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.DeprecationUtil;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HighlightInfoType {
    @NonNls
    public static final String UNUSED_SYMBOL_SHORT_NAME = "unused";
    @NonNls
    public static final String UNUSED_SYMBOL_DISPLAY_NAME = InspectionsBundle.message("inspection.dead.code.display.name", new Object[0]);
    @Deprecated
    @NonNls
    public static final String UNUSED_SYMBOL_ID = "UnusedDeclaration";
    public static final HighlightInfoType ERROR = new HighlightInfoTypeImpl(HighlightSeverity.ERROR, CodeInsightColors.ERRORS_ATTRIBUTES);
    public static final HighlightInfoType WARNING = new HighlightInfoTypeImpl(HighlightSeverity.WARNING, CodeInsightColors.WARNINGS_ATTRIBUTES);
    public static final HighlightInfoType INFO = new HighlightInfoTypeImpl(HighlightSeverity.INFO, CodeInsightColors.INFO_ATTRIBUTES);
    public static final HighlightInfoType WEAK_WARNING = new HighlightInfoTypeImpl(HighlightSeverity.WEAK_WARNING, CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
    public static final HighlightInfoType INFORMATION = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.INFORMATION_ATTRIBUTES);
    public static final HighlightInfoType WRONG_REF = new HighlightInfoTypeImpl(HighlightSeverity.ERROR, CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
    public static final HighlightInfoType GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER = new HighlightInfoTypeImpl(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING, CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING);
    public static final HighlightInfoType DUPLICATE_FROM_SERVER = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.DUPLICATE_FROM_SERVER);
    public static final HighlightInfoType UNUSED_SYMBOL = new HighlightInfoTypeSeverityByKey(HighlightDisplayKey.findOrRegister("unused", UNUSED_SYMBOL_DISPLAY_NAME, "unused"), CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES);
    public static final HighlightInfoType DEPRECATED = new HighlightInfoTypeSeverityByKey(HighlightDisplayKey.findOrRegister("Deprecation", DeprecationUtil.DEPRECATION_DISPLAY_NAME, "deprecation"), CodeInsightColors.DEPRECATED_ATTRIBUTES);
    public static final HighlightSeverity SYMBOL_TYPE_SEVERITY = new HighlightSeverity("SYMBOL_TYPE_SEVERITY", HighlightSeverity.INFORMATION.myVal - 2);
    @Deprecated
    public static final HighlightInfoType LOCAL_VARIABLE = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.LOCAL_VARIABLE_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType INSTANCE_FIELD = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.INSTANCE_FIELD_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType INSTANCE_FINAL_FIELD = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.INSTANCE_FINAL_FIELD_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType STATIC_FIELD = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.STATIC_FIELD_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType STATIC_FINAL_FIELD = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.STATIC_FINAL_FIELD_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType PARAMETER = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.PARAMETER_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType METHOD_CALL = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.METHOD_CALL_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType METHOD_DECLARATION = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.METHOD_DECLARATION_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType CONSTRUCTOR_CALL = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.CONSTRUCTOR_CALL_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType CONSTRUCTOR_DECLARATION = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.CONSTRUCTOR_DECLARATION_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType STATIC_METHOD = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.STATIC_METHOD_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType ABSTRACT_METHOD = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.ABSTRACT_METHOD_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType INHERITED_METHOD = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.INHERITED_METHOD_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType CLASS_NAME = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.CLASS_NAME_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType ANONYMOUS_CLASS_NAME = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.ANONYMOUS_CLASS_NAME_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType INTERFACE_NAME = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.INTERFACE_NAME_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType ENUM_NAME = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.ENUM_NAME_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType TYPE_PARAMETER_NAME = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.TYPE_PARAMETER_NAME_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType ABSTRACT_CLASS_NAME = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.ABSTRACT_CLASS_NAME_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType ANNOTATION_NAME = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.ANNOTATION_NAME_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType ANNOTATION_ATTRIBUTE_NAME = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.ANNOTATION_ATTRIBUTE_NAME_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType REASSIGNED_LOCAL_VARIABLE = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.REASSIGNED_LOCAL_VARIABLE_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType REASSIGNED_PARAMETER = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.REASSIGNED_PARAMETER_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType IMPLICIT_ANONYMOUS_CLASS_PARAMETER = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.IMPLICIT_ANONYMOUS_CLASS_PARAMETER_ATTRIBUTES);
    public static final HighlightInfoType TODO = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.TODO_DEFAULT_ATTRIBUTES, false);
    public static final HighlightInfoType UNHANDLED_EXCEPTION = new HighlightInfoTypeImpl(HighlightSeverity.ERROR, CodeInsightColors.ERRORS_ATTRIBUTES);
    public static final HighlightSeverity INJECTED_FRAGMENT_SEVERITY = new HighlightSeverity("INJECTED_FRAGMENT", HighlightInfoType.SYMBOL_TYPE_SEVERITY.myVal - 1);
    public static final HighlightInfoType INJECTED_LANGUAGE_FRAGMENT = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.INFORMATION_ATTRIBUTES);
    public static final HighlightInfoType INJECTED_LANGUAGE_BACKGROUND = new HighlightInfoTypeImpl(INJECTED_FRAGMENT_SEVERITY, CodeInsightColors.INFORMATION_ATTRIBUTES);
    public static final HighlightSeverity ELEMENT_UNDER_CARET_SEVERITY = new HighlightSeverity("ELEMENT_UNDER_CARET", HighlightSeverity.ERROR.myVal + 1);
    public static final HighlightInfoType ELEMENT_UNDER_CARET_READ = new HighlightInfoTypeImpl(ELEMENT_UNDER_CARET_SEVERITY, EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES);
    public static final HighlightInfoType ELEMENT_UNDER_CARET_WRITE = new HighlightInfoTypeImpl(ELEMENT_UNDER_CARET_SEVERITY, EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES);

    @NotNull
    public HighlightSeverity getSeverity(@Nullable PsiElement var1);

    public TextAttributesKey getAttributesKey();

    public static interface UpdateOnTypingSuppressible {
        public boolean needsUpdateOnTyping();
    }

    public static interface Iconable {
        public Icon getIcon();
    }

    public static class HighlightInfoTypeSeverityByKey
    implements HighlightInfoType {
        static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.HighlightInfoType.HighlightInfoTypeSeverityByKey");
        private final TextAttributesKey myAttributesKey;
        private final HighlightDisplayKey myToolKey;

        public HighlightInfoTypeSeverityByKey(HighlightDisplayKey severityKey, TextAttributesKey attributesKey) {
            this.myToolKey = severityKey;
            this.myAttributesKey = attributesKey;
        }

        @Override
        @NotNull
        public HighlightSeverity getSeverity(PsiElement psiElement) {
            InspectionProfile profile = psiElement == null ? (InspectionProfile)InspectionProfileManager.getInstance().getRootProfile() : InspectionProjectProfileManager.getInstance(psiElement.getProject()).getInspectionProfile();
            HighlightDisplayLevel level = profile.getErrorLevel(this.myToolKey, psiElement);
            LOG.assertTrue(level != HighlightDisplayLevel.DO_NOT_SHOW);
            HighlightSeverity highlightSeverity = level.getSeverity();
            if (highlightSeverity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeSeverityByKey", "getSeverity"));
            }
            return highlightSeverity;
        }

        @Override
        public TextAttributesKey getAttributesKey() {
            return this.myAttributesKey;
        }

        public String toString() {
            return "HighlightInfoTypeSeverityByKey[severity=" + this.myToolKey + ", key=" + this.myAttributesKey + "]";
        }

        public HighlightDisplayKey getSeverityKey() {
            return this.myToolKey;
        }
    }

    public static class HighlightInfoTypeImpl
    implements HighlightInfoType,
    UpdateOnTypingSuppressible {
        private final HighlightSeverity mySeverity;
        private final TextAttributesKey myAttributesKey;
        private boolean myNeedsUpdateOnTyping;

        HighlightInfoTypeImpl(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeImpl", "<init>"));
            }
            this.mySeverity = new HighlightSeverity(element);
            this.myAttributesKey = new TextAttributesKey(element);
        }

        public HighlightInfoTypeImpl(@NotNull HighlightSeverity severity, TextAttributesKey attributesKey) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeImpl", "<init>"));
            }
            this(severity, attributesKey, true);
        }

        public HighlightInfoTypeImpl(@NotNull HighlightSeverity severity, TextAttributesKey attributesKey, boolean needsUpdateOnTyping) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeImpl", "<init>"));
            }
            this.mySeverity = severity;
            this.myAttributesKey = attributesKey;
            this.myNeedsUpdateOnTyping = needsUpdateOnTyping;
        }

        @Override
        @NotNull
        public HighlightSeverity getSeverity(@Nullable PsiElement psiElement) {
            HighlightSeverity highlightSeverity = this.mySeverity;
            if (highlightSeverity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeImpl", "getSeverity"));
            }
            return highlightSeverity;
        }

        @Override
        public TextAttributesKey getAttributesKey() {
            return this.myAttributesKey;
        }

        public String toString() {
            return "HighlightInfoTypeImpl[severity=" + this.mySeverity + ", key=" + this.myAttributesKey + "]";
        }

        public void writeExternal(Element element) {
            try {
                this.mySeverity.writeExternal(element);
            }
            catch (WriteExternalException e) {
                throw new RuntimeException(e);
            }
            this.myAttributesKey.writeExternal(element);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HighlightInfoTypeImpl that = (HighlightInfoTypeImpl)o;
            if (!Comparing.equal(this.myAttributesKey, that.myAttributesKey)) {
                return false;
            }
            return this.mySeverity.equals(that.mySeverity);
        }

        public int hashCode() {
            int result = this.mySeverity.hashCode();
            result = 29 * result + this.myAttributesKey.hashCode();
            return result;
        }

        @Override
        public boolean needsUpdateOnTyping() {
            return this.myNeedsUpdateOnTyping;
        }
    }
}

