/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlErrorQuickFixProvider
implements ErrorQuickFixProvider {
    @NonNls
    private static final String AMP_ENTITY = "&amp;";

    @Override
    public void registerErrorQuickFix(@NotNull PsiErrorElement element, @NotNull HighlightInfo highlightInfo) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider", "registerErrorQuickFix"));
        }
        if (highlightInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfo", "com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider", "registerErrorQuickFix"));
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class) != null) {
            XmlErrorQuickFixProvider.registerXmlErrorQuickFix(element, highlightInfo);
        }
    }

    private static void registerXmlErrorQuickFix(final PsiErrorElement element, HighlightInfo highlightInfo) {
        String text = element.getErrorDescription();
        if (text != null && text.startsWith(XmlErrorMessages.message("unescaped.ampersand", new Object[0]))) {
            QuickFixAction.registerQuickFixAction(highlightInfo, new IntentionAction(){

                @Override
                @NotNull
                public String getText() {
                    String string = XmlErrorMessages.message("escape.ampersand.quickfix", new Object[0]);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider$1", "getText"));
                    }
                    return string;
                }

                @Override
                @NotNull
                public String getFamilyName() {
                    String string = this.getText();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider$1", "getFamilyName"));
                    }
                    return string;
                }

                @Override
                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider$1", "isAvailable"));
                    }
                    return true;
                }

                @Override
                public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider$1", "invoke"));
                    }
                    if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                        return;
                    }
                    int textOffset = element.getTextOffset();
                    editor.getDocument().replaceString(textOffset, textOffset + 1, XmlErrorQuickFixProvider.AMP_ENTITY);
                }

                @Override
                public boolean startInWriteAction() {
                    return true;
                }
            });
        }
    }
}

