/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTypeArgumentsFix
extends MethodArgumentFix {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix");
    public static ArgumentFixerActionFactory REGISTRAR = new MyFixerActionFactory();

    private AddTypeArgumentsFix(PsiExpressionList list, int i, PsiType toType, ArgumentFixerActionFactory factory) {
        super(list, i, toType, factory);
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myArgList.getExpressions().length == 1) {
            String string = QuickFixBundle.message("add.type.arguments.single.argument.text", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix", "getText"));
            }
            return string;
        }
        String string = QuickFixBundle.message("add.type.arguments.text", this.myIndex + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix", "getText"));
        }
        return string;
    }

    @Nullable
    public static PsiExpression addTypeArguments(PsiExpression expression, PsiType toType) {
        if (!PsiUtil.isLanguageLevel5OrHigher(expression)) {
            return null;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression;
            PsiReferenceParameterList list = methodCall.getMethodExpression().getParameterList();
            if (list == null || list.getTypeArguments().length > 0) {
                return null;
            }
            JavaResolveResult resolveResult = methodCall.resolveMethodGenerics();
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiType returnType = method.getReturnType();
                if (returnType == null) {
                    return null;
                }
                PsiTypeParameter[] typeParameters = method.getTypeParameters();
                if (typeParameters.length > 0) {
                    PsiType[] mappings = PsiType.createArray(typeParameters.length);
                    PsiResolveHelper helper = JavaPsiFacade.getInstance(expression.getProject()).getResolveHelper();
                    LanguageLevel level = PsiUtil.getLanguageLevel(expression);
                    for (int i = 0; i < typeParameters.length; ++i) {
                        PsiTypeParameter typeParameter = typeParameters[i];
                        PsiType substitution = helper.getSubstitutionForTypeParameter(typeParameter, returnType, toType, false, level);
                        if (substitution == null || PsiType.NULL.equals(substitution)) {
                            return null;
                        }
                        mappings[i] = GenericsUtil.eliminateWildcards(substitution, false);
                    }
                    PsiElementFactory factory = JavaPsiFacade.getInstance(expression.getProject()).getElementFactory();
                    PsiMethodCallExpression copy = (PsiMethodCallExpression)expression.copy();
                    PsiReferenceExpression methodExpression = copy.getMethodExpression();
                    PsiReferenceParameterList parameterList = methodExpression.getParameterList();
                    LOG.assertTrue(parameterList != null);
                    for (PsiType mapping : mappings) {
                        parameterList.add(factory.createTypeElement(mapping));
                    }
                    if (methodExpression.getQualifierExpression() == null) {
                        PsiClass containingClass = method.getContainingClass();
                        LOG.assertTrue(containingClass != null);
                        PsiExpression qualifierExpression = method.hasModifierProperty("static") ? factory.createReferenceExpression(containingClass) : RefactoringChangeUtil.createThisExpression(method.getManager(), null);
                        methodExpression.setQualifierExpression(qualifierExpression);
                    }
                    return (PsiExpression)JavaCodeStyleManager.getInstance(copy.getProject()).shortenClassReferences(copy);
                }
            }
        }
        return null;
    }

    private static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        private MyFixerActionFactory() {
        }

        @Override
        public AddTypeArgumentsFix createFix(PsiExpressionList list, int i, PsiType toType) {
            return new AddTypeArgumentsFix(list, i, toType, this);
        }

        @Override
        protected PsiExpression getModifiedArgument(PsiExpression expression, PsiType toType) throws IncorrectOperationException {
            return AddTypeArgumentsFix.addTypeArguments(expression, toType);
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exprType", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            if (parameterType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            return !(exprType instanceof PsiPrimitiveType) && !(parameterType instanceof PsiPrimitiveType) || TypeConversionUtil.boxingConversionApplicable(exprType, parameterType);
        }
    }
}

