/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.problems;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.Problem;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProblemImpl
implements Problem {
    private final VirtualFile virtualFile;
    private final HighlightInfo highlightInfo;
    private final boolean isSyntax;

    public ProblemImpl(@NotNull VirtualFile virtualFile, @NotNull HighlightInfo highlightInfo, boolean isSyntax) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/codeInsight/problems/ProblemImpl", "<init>"));
        }
        if (highlightInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfo", "com/intellij/codeInsight/problems/ProblemImpl", "<init>"));
        }
        this.isSyntax = isSyntax;
        this.virtualFile = virtualFile;
        this.highlightInfo = highlightInfo;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.virtualFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/problems/ProblemImpl", "getVirtualFile"));
        }
        return virtualFile;
    }

    public boolean isSyntaxOnly() {
        return this.isSyntax;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProblemImpl problem = (ProblemImpl)o;
        if (this.isSyntax != problem.isSyntax) {
            return false;
        }
        if (!this.highlightInfo.equals(problem.highlightInfo)) {
            return false;
        }
        return this.virtualFile.equals(problem.virtualFile);
    }

    public int hashCode() {
        int result = this.virtualFile.hashCode();
        result = 31 * result + this.highlightInfo.hashCode();
        result = 31 * result + (this.isSyntax ? 1 : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return "Problem: " + this.highlightInfo;
    }
}

