/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnonymousCanBeMethodReferenceInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance("#" + AnonymousCanBeMethodReferenceInspection.class.getName());
    public boolean reportNotAnnotatedInterfaces = true;

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Anonymous type can be replaced with method reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection", "getDisplayName"));
        }
        return "Anonymous type can be replaced with method reference";
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("Anonymous2MethodRef" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection", "getShortName"));
        }
        return "Anonymous2MethodRef";
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Report when interface is not annotated with @FunctionalInterface", this, "reportNotAnnotatedInterfaces");
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                PsiJavaCodeReferenceElement classReference;
                PsiElement parent;
                PsiMethod resolveMethod;
                PsiMethod method;
                PsiCodeBlock body;
                PsiCallExpression callExpression;
                super.visitAnonymousClass(aClass);
                if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, true, AnonymousCanBeMethodReferenceInspection.this.reportNotAnnotatedInterfaces, Collections.emptySet()) && (callExpression = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(body = (method = aClass.getMethods()[0]).getBody(), method.getParameterList().getParameters(), aClass.getBaseClassType(), aClass.getParent())) != null && (resolveMethod = callExpression.resolveMethod()) != method && !AnonymousCanBeLambdaInspection.functionalInterfaceMethodReferenced(resolveMethod, aClass, callExpression) && (parent = aClass.getParent()) instanceof PsiNewExpression && (classReference = ((PsiNewExpression)parent).getClassOrAnonymousClassReference()) != null) {
                    PsiElement lBrace = aClass.getLBrace();
                    LOG.assertTrue(lBrace != null);
                    TextRange rangeInElement = new TextRange(0, aClass.getStartOffsetInParent() + lBrace.getStartOffsetInParent());
                    holder.registerProblem(parent, "Anonymous #ref #loc can be replaced with method reference", ProblemHighlightType.LIKE_UNUSED_SYMBOL, rangeInElement, new ReplaceWithMethodRefFix());
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    static void replaceWithMethodReference(@NotNull Project project, String methodRefText, PsiType castType, PsiElement replacementTarget) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection", "replaceWithMethodReference"));
        }
        List<PsiComment> comments = ContainerUtil.map(PsiTreeUtil.findChildrenOfType(replacementTarget, PsiComment.class), comment -> (PsiComment)comment.copy());
        if (methodRefText != null) {
            PsiElement anchor;
            String canonicalText = castType.getCanonicalText();
            PsiExpression psiExpression = JavaPsiFacade.getElementFactory(project).createExpressionFromText("(" + canonicalText + ")" + methodRefText, replacementTarget);
            PsiElement castExpr = replacementTarget.replace(psiExpression);
            if (RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)castExpr)) {
                PsiExpression operand = ((PsiTypeCastExpression)castExpr).getOperand();
                LOG.assertTrue(operand != null);
                castExpr = castExpr.replace(operand);
            }
            if ((anchor = PsiTreeUtil.getParentOfType(castExpr, PsiStatement.class)) == null) {
                anchor = castExpr;
            }
            for (PsiComment comment2 : comments) {
                anchor.getParent().addBefore(comment2, anchor);
            }
            JavaCodeStyleManager.getInstance(project).shortenClassReferences(castExpr);
        }
    }

    private static class ReplaceWithMethodRefFix
    implements LocalQuickFix {
        private ReplaceWithMethodRefFix() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("Replace with method reference" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "getName"));
            }
            return "Replace with method reference";
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiNewExpression) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                    return;
                }
                PsiAnonymousClass anonymousClass = ((PsiNewExpression)element).getAnonymousClass();
                if (anonymousClass == null) {
                    return;
                }
                PsiMethod[] methods = anonymousClass.getMethods();
                if (methods.length != 1) {
                    return;
                }
                PsiParameter[] parameters = methods[0].getParameterList().getParameters();
                String methodRefText = LambdaCanBeMethodReferenceInspection.convertToMethodReference(methods[0].getBody(), parameters, anonymousClass.getBaseClassType(), anonymousClass.getParent());
                AnonymousCanBeMethodReferenceInspection.replaceWithMethodReference(project, methodRefText, anonymousClass.getBaseClassType(), anonymousClass.getParent());
            }
        }
    }
}

