/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionUtil {
    private static final String LOC_MARKER = " #loc";

    @NotNull
    public static String createInspectionMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInspection/GlobalInspectionUtil", "createInspectionMessage"));
        }
        String string = message + LOC_MARKER;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/GlobalInspectionUtil", "createInspectionMessage"));
        }
        return string;
    }

    public static void createProblem(@NotNull PsiElement elt, @NotNull HighlightInfo info, TextRange range, @Nullable ProblemGroup problemGroup, @NotNull InspectionManager manager, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor, @NotNull GlobalInspectionContext globalContext) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/codeInspection/GlobalInspectionUtil", "createProblem"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInspection/GlobalInspectionUtil", "createProblem"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/GlobalInspectionUtil", "createProblem"));
        }
        if (problemDescriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptionsProcessor", "com/intellij/codeInspection/GlobalInspectionUtil", "createProblem"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/GlobalInspectionUtil", "createProblem"));
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (info.quickFixActionRanges != null) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> actionRange : info.quickFixActionRanges) {
                IntentionAction action = actionRange.getFirst().getAction();
                if (!(action instanceof LocalQuickFix)) continue;
                fixes.add((LocalQuickFix)((Object)action));
            }
        }
        ProblemDescriptor descriptor = manager.createProblemDescriptor(elt, range, GlobalInspectionUtil.createInspectionMessage(StringUtil.notNullize(info.getDescription())), HighlightInfo.convertType(info.type), false, fixes.isEmpty() ? null : fixes.toArray(new LocalQuickFix[fixes.size()]));
        descriptor.setProblemGroup(problemGroup);
        problemDescriptionsProcessor.addProblemElement(GlobalInspectionContextUtil.retrieveRefElement(elt, globalContext), descriptor);
    }
}

