/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ContractInferenceInterpreter {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.dataFlow.ContractInferenceInterpreter");
    private final PsiMethod myMethod;
    private final MethodContract.ValueConstraint[] myEmptyConstraints;

    public ContractInferenceInterpreter(PsiMethod method) {
        this.myMethod = method;
        this.myEmptyConstraints = MethodContract.createConstraintArray(this.myMethod.getParameterList().getParametersCount());
    }

    List<MethodContract> inferContracts() {
        List<MethodContract> compatible;
        boolean notNull;
        List<MethodContract> contracts = this.doInferContracts();
        if (contracts.isEmpty()) {
            return contracts;
        }
        PsiTypeElement typeElement = this.myMethod.getReturnTypeElement();
        PsiType returnType = typeElement == null ? null : typeElement.getType();
        boolean referenceTypeReturned = !(returnType instanceof PsiPrimitiveType);
        boolean bl = notNull = referenceTypeReturned && NullableNotNullManager.getInstance(this.myMethod.getProject()).isNotNull(this.myMethod, false);
        if (referenceTypeReturned) {
            contracts = ContractInferenceInterpreter.boxReturnValues(contracts);
        }
        if ((compatible = ContainerUtil.filter(contracts, contract -> {
            if (notNull && contract.returnValue == MethodContract.ValueConstraint.NOT_NULL_VALUE) {
                return false;
            }
            return InferenceFromSourceUtil.isReturnTypeCompatible(returnType, contract.returnValue);
        })).size() > 10) {
            LOG.debug("Too many contracts for " + PsiUtil.getMemberQualifiedName(this.myMethod) + ", shrinking the list");
            return compatible.subList(0, 10);
        }
        return compatible;
    }

    @NotNull
    private static List<MethodContract> boxReturnValues(List<MethodContract> contracts) {
        List<MethodContract> list = ContainerUtil.mapNotNull(contracts, contract -> {
            if (contract.returnValue == MethodContract.ValueConstraint.FALSE_VALUE || contract.returnValue == MethodContract.ValueConstraint.TRUE_VALUE) {
                return new MethodContract(contract.arguments, MethodContract.ValueConstraint.NOT_NULL_VALUE);
            }
            return contract;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "boxReturnValues"));
        }
        return list;
    }

    private List<MethodContract> doInferContracts() {
        PsiStatement[] statements;
        PsiCodeBlock body = this.myMethod.getBody();
        PsiStatement[] psiStatementArray = statements = body == null ? PsiStatement.EMPTY_ARRAY : body.getStatements();
        if (statements.length == 0) {
            return Collections.emptyList();
        }
        if (statements.length == 1) {
            List<MethodContract> result;
            if (statements[0] instanceof PsiReturnStatement) {
                List<MethodContract> result2 = this.handleDelegation(((PsiReturnStatement)statements[0]).getReturnValue(), false);
                if (result2 != null) {
                    return result2;
                }
            } else if (statements[0] instanceof PsiExpressionStatement && ((PsiExpressionStatement)statements[0]).getExpression() instanceof PsiMethodCallExpression && (result = this.handleDelegation(((PsiExpressionStatement)statements[0]).getExpression(), false)) != null) {
                return result;
            }
        }
        return this.visitStatements(Collections.singletonList(this.myEmptyConstraints), statements);
    }

    @Nullable
    private List<MethodContract> handleDelegation(PsiExpression expression, boolean negated) {
        if (expression instanceof PsiParenthesizedExpression) {
            return this.handleDelegation(((PsiParenthesizedExpression)expression).getExpression(), negated);
        }
        if (expression instanceof PsiPrefixExpression && ((PsiPrefixExpression)expression).getOperationTokenType() == JavaTokenType.EXCL) {
            return this.handleDelegation(((PsiPrefixExpression)expression).getOperand(), !negated);
        }
        if (expression instanceof PsiMethodCallExpression) {
            return this.handleCallDelegation((PsiMethodCallExpression)expression, negated);
        }
        return null;
    }

    private List<MethodContract> handleCallDelegation(PsiMethodCallExpression expression, boolean negated) {
        JavaResolveResult result = expression.resolveMethodGenerics();
        PsiMethod targetMethod = (PsiMethod)result.getElement();
        if (targetMethod == null) {
            return Collections.emptyList();
        }
        PsiParameter[] parameters = targetMethod.getParameterList().getParameters();
        PsiExpression[] arguments = expression.getArgumentList().getExpressions();
        boolean varArgCall = MethodCallInstruction.isVarArgCall(targetMethod, result.getSubstitutor(), arguments, parameters);
        boolean notNull = NullableNotNullManager.isNotNull(targetMethod);
        List<MethodContract> fromDelegate = ContainerUtil.mapNotNull(ControlFlowAnalyzer.getMethodContracts(targetMethod), delegateContract -> {
            MethodContract.ValueConstraint returnValue;
            MethodContract.ValueConstraint[] answer = this.myEmptyConstraints;
            for (int i = 0; i < delegateContract.arguments.length; ++i) {
                if (i >= arguments.length) {
                    return null;
                }
                MethodContract.ValueConstraint argConstraint = delegateContract.arguments[i];
                if (argConstraint == MethodContract.ValueConstraint.ANY_VALUE) continue;
                if (varArgCall && i >= parameters.length - 1) {
                    if (argConstraint != MethodContract.ValueConstraint.NULL_VALUE) break;
                    return null;
                }
                int paramIndex = this.resolveParameter(arguments[i]);
                if (!(paramIndex < 0 ? argConstraint != ContractInferenceInterpreter.getLiteralConstraint(arguments[i]) : (answer = this.withConstraint(answer, paramIndex, argConstraint)) == null)) continue;
                return null;
            }
            MethodContract.ValueConstraint valueConstraint = returnValue = negated ? ContractInferenceInterpreter.negateConstraint(delegateContract.returnValue) : delegateContract.returnValue;
            if (notNull && returnValue != MethodContract.ValueConstraint.THROW_EXCEPTION) {
                returnValue = MethodContract.ValueConstraint.NOT_NULL_VALUE;
            }
            return answer == null ? null : new MethodContract(answer, returnValue);
        });
        if (notNull) {
            return ContainerUtil.concat(fromDelegate, Collections.singletonList(new MethodContract(this.myEmptyConstraints, MethodContract.ValueConstraint.NOT_NULL_VALUE)));
        }
        return fromDelegate;
    }

    @NotNull
    private List<MethodContract> visitExpression(List<MethodContract.ValueConstraint[]> states, @Nullable PsiExpression expr) {
        PsiMethod method;
        int parameter;
        if (states.isEmpty()) {
            List<MethodContract> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (states.size() > 300) {
            List<MethodContract> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (expr instanceof PsiPolyadicExpression) {
            PsiExpression[] operands = ((PsiPolyadicExpression)expr).getOperands();
            IElementType op = ((PsiPolyadicExpression)expr).getOperationTokenType();
            if (operands.length == 2 && (op == JavaTokenType.EQEQ || op == JavaTokenType.NE)) {
                List<MethodContract> list = this.visitEqualityComparison(states, operands[0], operands[1], op == JavaTokenType.EQEQ);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
                }
                return list;
            }
            if (op == JavaTokenType.ANDAND || op == JavaTokenType.OROR) {
                List<MethodContract> list = this.visitLogicalOperation(operands, op == JavaTokenType.ANDAND, states);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
                }
                return list;
            }
        }
        if (expr instanceof PsiConditionalExpression) {
            List<MethodContract> conditionResults = this.visitExpression(states, ((PsiConditionalExpression)expr).getCondition());
            List<MethodContract> list = ContainerUtil.concat(this.visitExpression(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.TRUE_VALUE), ((PsiConditionalExpression)expr).getThenExpression()), this.visitExpression(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.FALSE_VALUE), ((PsiConditionalExpression)expr).getElseExpression()));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (expr instanceof PsiParenthesizedExpression) {
            List<MethodContract> list = this.visitExpression(states, ((PsiParenthesizedExpression)expr).getExpression());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (expr instanceof PsiTypeCastExpression) {
            List<MethodContract> list = this.visitExpression(states, ((PsiTypeCastExpression)expr).getOperand());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (expr instanceof PsiPrefixExpression && ((PsiPrefixExpression)expr).getOperationTokenType() == JavaTokenType.EXCL) {
            ArrayList<MethodContract> result = ContainerUtil.newArrayList();
            for (MethodContract contract : this.visitExpression(states, ((PsiPrefixExpression)expr).getOperand())) {
                if (contract.returnValue != MethodContract.ValueConstraint.TRUE_VALUE && contract.returnValue != MethodContract.ValueConstraint.FALSE_VALUE) continue;
                result.add(new MethodContract(contract.arguments, ContractInferenceInterpreter.negateConstraint(contract.returnValue)));
            }
            ArrayList<MethodContract> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return arrayList;
        }
        if (expr instanceof PsiInstanceOfExpression && (parameter = this.resolveParameter(((PsiInstanceOfExpression)expr).getOperand())) >= 0) {
            List<MethodContract> list = ContainerUtil.mapNotNull(states, state -> this.contractWithConstraint((MethodContract.ValueConstraint[])state, parameter, MethodContract.ValueConstraint.NULL_VALUE, MethodContract.ValueConstraint.FALSE_VALUE));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (expr instanceof PsiNewExpression) {
            List<MethodContract> list = ContractInferenceInterpreter.toContracts(states, MethodContract.ValueConstraint.NOT_NULL_VALUE);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (expr instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)expr).resolveMethod()) != null && NullableNotNullManager.isNotNull(method)) {
            List<MethodContract> list = ContractInferenceInterpreter.toContracts(states, MethodContract.ValueConstraint.NOT_NULL_VALUE);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        MethodContract.ValueConstraint constraint = ContractInferenceInterpreter.getLiteralConstraint(expr);
        if (constraint != null) {
            List<MethodContract> list = ContractInferenceInterpreter.toContracts(states, constraint);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        int paramIndex = this.resolveParameter(expr);
        if (paramIndex >= 0) {
            ArrayList<MethodContract> result = ContainerUtil.newArrayList();
            for (MethodContract.ValueConstraint[] state2 : states) {
                if (state2[paramIndex] != MethodContract.ValueConstraint.ANY_VALUE) {
                    result.add(new MethodContract(state2, state2[paramIndex]));
                    continue;
                }
                if (!ContractInferenceInterpreter.textMatches(this.getParameter(paramIndex).getTypeElement(), "boolean")) continue;
                ContainerUtil.addIfNotNull(result, this.contractWithConstraint(state2, paramIndex, MethodContract.ValueConstraint.TRUE_VALUE, MethodContract.ValueConstraint.TRUE_VALUE));
                ContainerUtil.addIfNotNull(result, this.contractWithConstraint(state2, paramIndex, MethodContract.ValueConstraint.FALSE_VALUE, MethodContract.ValueConstraint.FALSE_VALUE));
            }
            ArrayList<MethodContract> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return arrayList;
        }
        List<MethodContract> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
        }
        return list;
    }

    @Nullable
    private MethodContract contractWithConstraint(MethodContract.ValueConstraint[] state, int parameter, MethodContract.ValueConstraint paramConstraint, MethodContract.ValueConstraint returnValue) {
        MethodContract.ValueConstraint[] newState = this.withConstraint(state, parameter, paramConstraint);
        return newState == null ? null : new MethodContract(newState, returnValue);
    }

    private static boolean textMatches(@Nullable PsiTypeElement typeElement, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "textMatches"));
        }
        return typeElement != null && typeElement.textMatches(text);
    }

    private List<MethodContract> visitEqualityComparison(List<MethodContract.ValueConstraint[]> states, PsiExpression op1, PsiExpression op2, boolean equality) {
        int parameter = this.resolveParameter(op1);
        MethodContract.ValueConstraint constraint = ContractInferenceInterpreter.getLiteralConstraint(op2);
        if (parameter < 0 || constraint == null) {
            parameter = this.resolveParameter(op2);
            constraint = ContractInferenceInterpreter.getLiteralConstraint(op1);
        }
        if (parameter >= 0 && constraint != null) {
            ArrayList<MethodContract> result = ContainerUtil.newArrayList();
            for (MethodContract.ValueConstraint[] state : states) {
                if (constraint == MethodContract.ValueConstraint.NOT_NULL_VALUE) {
                    if (this.getParameter(parameter).getType() instanceof PsiPrimitiveType) continue;
                    ContainerUtil.addIfNotNull(result, this.contractWithConstraint(state, parameter, MethodContract.ValueConstraint.NULL_VALUE, equality ? MethodContract.ValueConstraint.FALSE_VALUE : MethodContract.ValueConstraint.TRUE_VALUE));
                    continue;
                }
                ContainerUtil.addIfNotNull(result, this.contractWithConstraint(state, parameter, constraint, equality ? MethodContract.ValueConstraint.TRUE_VALUE : MethodContract.ValueConstraint.FALSE_VALUE));
                ContainerUtil.addIfNotNull(result, this.contractWithConstraint(state, parameter, ContractInferenceInterpreter.negateConstraint(constraint), equality ? MethodContract.ValueConstraint.FALSE_VALUE : MethodContract.ValueConstraint.TRUE_VALUE));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private PsiParameter getParameter(int parameter) {
        return this.myMethod.getParameterList().getParameters()[parameter];
    }

    private static List<MethodContract> toContracts(List<MethodContract.ValueConstraint[]> states, MethodContract.ValueConstraint constraint) {
        return ContainerUtil.map(states, state -> new MethodContract((MethodContract.ValueConstraint[])state, constraint));
    }

    private List<MethodContract> visitLogicalOperation(PsiExpression[] operands, boolean conjunction, List<MethodContract.ValueConstraint[]> states) {
        MethodContract.ValueConstraint breakValue = conjunction ? MethodContract.ValueConstraint.FALSE_VALUE : MethodContract.ValueConstraint.TRUE_VALUE;
        ArrayList<MethodContract> finalStates = ContainerUtil.newArrayList();
        for (PsiExpression operand : operands) {
            List<MethodContract> opResults = this.visitExpression(states, operand);
            finalStates.addAll(ContainerUtil.filter(opResults, contract -> contract.returnValue == breakValue));
            states = ContractInferenceInterpreter.antecedentsReturning(opResults, ContractInferenceInterpreter.negateConstraint(breakValue));
        }
        finalStates.addAll(ContractInferenceInterpreter.toContracts(states, ContractInferenceInterpreter.negateConstraint(breakValue)));
        return finalStates;
    }

    private static List<MethodContract.ValueConstraint[]> antecedentsReturning(List<MethodContract> values, MethodContract.ValueConstraint result) {
        return ContainerUtil.mapNotNull(values, contract -> contract.returnValue == result ? contract.arguments : null);
    }

    @NotNull
    private List<MethodContract> visitStatements(List<MethodContract.ValueConstraint[]> states, PsiStatement ... statements) {
        ArrayList<MethodContract> result = ContainerUtil.newArrayList();
        for (PsiStatement statement : statements) {
            List<MethodContract> conditionResults;
            if (statement instanceof PsiBlockStatement) {
                result.addAll(this.visitStatements(states, ((PsiBlockStatement)statement).getCodeBlock().getStatements()));
                break;
            }
            if (statement instanceof PsiIfStatement) {
                conditionResults = this.visitExpression(states, ((PsiIfStatement)statement).getCondition());
                PsiStatement thenBranch = ((PsiIfStatement)statement).getThenBranch();
                if (thenBranch != null) {
                    result.addAll(this.visitStatements(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.TRUE_VALUE), thenBranch));
                }
                List<MethodContract.ValueConstraint[]> falseStates = ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.FALSE_VALUE);
                PsiStatement elseBranch = ((PsiIfStatement)statement).getElseBranch();
                if (elseBranch != null) {
                    result.addAll(this.visitStatements(falseStates, elseBranch));
                    break;
                }
                states = falseStates;
                continue;
            }
            if (statement instanceof PsiThrowStatement) {
                result.addAll(ContractInferenceInterpreter.toContracts(states, MethodContract.ValueConstraint.THROW_EXCEPTION));
                break;
            }
            if (statement instanceof PsiReturnStatement) {
                result.addAll(this.visitExpression(states, ((PsiReturnStatement)statement).getReturnValue()));
                break;
            }
            if (statement instanceof PsiAssertStatement) {
                conditionResults = this.visitExpression(states, ((PsiAssertStatement)statement).getAssertCondition());
                result.addAll(ContractInferenceInterpreter.toContracts(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.FALSE_VALUE), MethodContract.ValueConstraint.THROW_EXCEPTION));
                break;
            }
            if (statement instanceof PsiDeclarationStatement && !ContractInferenceInterpreter.mayHaveSideEffects((PsiDeclarationStatement)statement)) continue;
            if (!(statement instanceof PsiDoWhileStatement)) break;
            result.addAll(this.visitStatements(states, ((PsiDoWhileStatement)statement).getBody()));
            break;
        }
        ArrayList<MethodContract> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitStatements"));
        }
        return arrayList;
    }

    private static boolean mayHaveSideEffects(PsiDeclarationStatement statement) {
        for (PsiElement element : statement.getDeclaredElements()) {
            PsiExpression initializer;
            if (!(element instanceof PsiVariable) || (initializer = ((PsiVariable)element).getInitializer()) == null || !SideEffectChecker.mayHaveSideEffects(initializer)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static MethodContract.ValueConstraint getLiteralConstraint(@Nullable PsiExpression expr) {
        if (expr instanceof PsiLiteralExpression) {
            if (expr.textMatches("true")) {
                return MethodContract.ValueConstraint.TRUE_VALUE;
            }
            if (expr.textMatches("false")) {
                return MethodContract.ValueConstraint.FALSE_VALUE;
            }
            if (expr.textMatches("null")) {
                return MethodContract.ValueConstraint.NULL_VALUE;
            }
            return MethodContract.ValueConstraint.NOT_NULL_VALUE;
        }
        return null;
    }

    private static MethodContract.ValueConstraint negateConstraint(@NotNull MethodContract.ValueConstraint constraint) {
        if (constraint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraint", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "negateConstraint"));
        }
        switch (constraint) {
            case NULL_VALUE: {
                return MethodContract.ValueConstraint.NOT_NULL_VALUE;
            }
            case NOT_NULL_VALUE: {
                return MethodContract.ValueConstraint.NULL_VALUE;
            }
            case TRUE_VALUE: {
                return MethodContract.ValueConstraint.FALSE_VALUE;
            }
            case FALSE_VALUE: {
                return MethodContract.ValueConstraint.TRUE_VALUE;
            }
        }
        return constraint;
    }

    private int resolveParameter(@Nullable PsiExpression expr) {
        if (expr instanceof PsiReferenceExpression && !((PsiReferenceExpression)expr).isQualified()) {
            String name = expr.getText();
            PsiParameter[] parameters = this.myMethod.getParameterList().getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                if (!name.equals(parameters[i].getName())) continue;
                return i;
            }
        }
        return -1;
    }

    @Nullable
    private MethodContract.ValueConstraint[] withConstraint(MethodContract.ValueConstraint[] constraints, int index, MethodContract.ValueConstraint constraint) {
        if (constraints[index] == constraint) {
            return constraints;
        }
        MethodContract.ValueConstraint negated = ContractInferenceInterpreter.negateConstraint(constraint);
        if (negated != constraint && constraints[index] == negated) {
            return null;
        }
        if (constraint == MethodContract.ValueConstraint.NULL_VALUE && NullableNotNullManager.isNotNull(this.getParameter(index))) {
            return null;
        }
        MethodContract.ValueConstraint[] copy = (MethodContract.ValueConstraint[])constraints.clone();
        copy[index] = constraint;
        return copy;
    }
}

