/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Ref;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiParameterPattern;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaPsiUtil {
    public static boolean isFinalField(PsiVariable var) {
        return var.hasModifierProperty("final") && !var.hasModifierProperty("transient") && var instanceof PsiField;
    }

    static PsiElement getEnclosingCodeBlock(PsiVariable variable, PsiElement context) {
        PsiAnonymousClass anon;
        PsiElement codeBlock;
        if (variable instanceof PsiParameter) {
            codeBlock = ((PsiParameter)variable).getDeclarationScope();
            if (codeBlock instanceof PsiMethod) {
                codeBlock = ((PsiMethod)codeBlock).getBody();
            }
        } else {
            codeBlock = variable instanceof PsiLocalVariable ? PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class) : DfaPsiUtil.getTopmostBlockInSameClass(context);
        }
        while (codeBlock != null && (anon = PsiTreeUtil.getParentOfType(codeBlock, PsiAnonymousClass.class)) != null) {
            codeBlock = PsiTreeUtil.getParentOfType((PsiElement)anon, PsiCodeBlock.class);
        }
        return codeBlock;
    }

    @NotNull
    public static Nullness getElementNullability(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner) {
        if (resultType != null) {
            for (PsiAnnotation annotation : resultType.getAnnotations()) {
                String qualifiedName = annotation.getQualifiedName();
                NullableNotNullManager nnn = NullableNotNullManager.getInstance(annotation.getProject());
                if (nnn.getNullables().contains(qualifiedName)) {
                    Nullness nullness = Nullness.NULLABLE;
                    if (nullness == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
                    }
                    return nullness;
                }
                if (!nnn.getNotNulls().contains(qualifiedName)) continue;
                Nullness nullness = Nullness.NOT_NULL;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
                }
                return nullness;
            }
        }
        if (owner == null || resultType instanceof PsiPrimitiveType) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        if (owner instanceof PsiEnumConstant || PsiUtil.isAnnotationMethod(owner)) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        if (owner instanceof PsiMethod && DfaPsiUtil.isEnumValueOf((PsiMethod)owner)) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        if (NullableNotNullManager.isNullable(owner)) {
            Nullness nullness = Nullness.NULLABLE;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        if (NullableNotNullManager.isNotNull(owner)) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        if (((PsiParameterPattern)PsiJavaPatterns.psiParameter().withParents(PsiParameterList.class, PsiLambdaExpression.class)).accepts(owner)) {
            PsiLambdaExpression lambda = (PsiLambdaExpression)owner.getParent().getParent();
            int index = lambda.getParameterList().getParameterIndex((PsiParameter)owner);
            PsiMethod sam = LambdaUtil.getFunctionalInterfaceMethod(lambda.getFunctionalInterfaceType());
            if (sam != null && index < sam.getParameterList().getParametersCount()) {
                Nullness nullness = DfaPsiUtil.getElementNullability(null, sam.getParameterList().getParameters()[index]);
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
                }
                return nullness;
            }
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
        }
        return nullness;
    }

    private static boolean isEnumValueOf(PsiMethod method) {
        PsiParameter[] parameters;
        PsiClass containingClass;
        return "valueOf".equals(method.getName()) && method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && containingClass.isEnum() && (parameters = method.getParameterList().getParameters()).length == 1 && parameters[0].getType().equalsToText("java.lang.String");
    }

    public static boolean isInitializedNotNull(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiMethod[] constructors = containingClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod method : constructors) {
            if (DfaPsiUtil.getNotNullInitializedFields(method, containingClass).contains(field)) continue;
            return false;
        }
        return true;
    }

    private static Set<PsiField> getNotNullInitializedFields(final PsiMethod constructor, final PsiClass containingClass) {
        if (!constructor.getLanguage().isKindOf(JavaLanguage.INSTANCE)) {
            return Collections.emptySet();
        }
        PsiCodeBlock body = constructor.getBody();
        if (body == null) {
            return Collections.emptySet();
        }
        return CachedValuesManager.getCachedValue(constructor, new CachedValueProvider<Set<PsiField>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<Set<PsiField>> compute() {
                PsiCodeBlock body = constructor.getBody();
                final HashMap map = ContainerUtil.newHashMap();
                StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(false, false){

                    private boolean isCallExposingNonInitializedFields(Instruction instruction) {
                        if (!(instruction instanceof MethodCallInstruction) || ((MethodCallInstruction)instruction).getMethodType() != MethodCallInstruction.MethodType.REGULAR_METHOD_CALL) {
                            return false;
                        }
                        PsiCall call = ((MethodCallInstruction)instruction).getCallExpression();
                        if (call == null) {
                            return false;
                        }
                        if (call instanceof PsiMethodCallExpression && DfaValueFactory.isEffectivelyUnqualified(((PsiMethodCallExpression)call).getMethodExpression())) {
                            return true;
                        }
                        PsiExpressionList argumentList = call.getArgumentList();
                        if (argumentList != null) {
                            for (PsiExpression expression : argumentList.getExpressions()) {
                                if (!(expression instanceof PsiThisExpression)) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    @Override
                    @NotNull
                    protected DfaInstructionState[] acceptInstruction(@NotNull InstructionVisitor visitor, @NotNull DfaInstructionState instructionState) {
                        if (visitor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1$1", "acceptInstruction"));
                        }
                        if (instructionState == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructionState", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1$1", "acceptInstruction"));
                        }
                        Instruction instruction = instructionState.getInstruction();
                        if (this.isCallExposingNonInitializedFields(instruction) || instruction instanceof ReturnInstruction && !((ReturnInstruction)instruction).isViaException()) {
                            for (PsiField field : containingClass.getFields()) {
                                if (!instructionState.getMemoryState().isNotNull(this.getFactory().getVarFactory().createVariableValue(field, false))) {
                                    map.put(field, false);
                                    continue;
                                }
                                if (map.containsKey(field)) continue;
                                map.put(field, true);
                            }
                            if (DfaInstructionState.EMPTY_ARRAY == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1$1", "acceptInstruction"));
                            }
                            return DfaInstructionState.EMPTY_ARRAY;
                        }
                        DfaInstructionState[] dfaInstructionStateArray = super.acceptInstruction(visitor, instructionState);
                        if (dfaInstructionStateArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1$1", "acceptInstruction"));
                        }
                        return dfaInstructionStateArray;
                    }
                };
                RunnerResult rc = dfaRunner.analyzeMethod(body, new StandardInstructionVisitor());
                HashSet notNullFields = ContainerUtil.newHashSet();
                if (rc == RunnerResult.OK) {
                    for (PsiField field : map.keySet()) {
                        if (!((Boolean)map.get(field)).booleanValue()) continue;
                        notNullFields.add(field);
                    }
                }
                return CachedValueProvider.Result.create(notNullFields, constructor, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
            }
        });
    }

    public static List<PsiExpression> findAllConstructorInitializers(PsiField field) {
        List<PsiExpression> result = ContainerUtil.createLockFreeCopyOnWriteList();
        ContainerUtil.addIfNotNull(result, field.getInitializer());
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && !(containingClass instanceof PsiCompiledElement)) {
            result.addAll(DfaPsiUtil.getAllConstructorFieldInitializers(containingClass).get(field));
        }
        return result;
    }

    private static MultiMap<PsiField, PsiExpression> getAllConstructorFieldInitializers(final PsiClass psiClass) {
        if (psiClass instanceof PsiCompiledElement) {
            return MultiMap.EMPTY;
        }
        return CachedValuesManager.getCachedValue(psiClass, new CachedValueProvider<MultiMap<PsiField, PsiExpression>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<MultiMap<PsiField, PsiExpression>> compute() {
                final HashSet fieldNames = ContainerUtil.newHashSet();
                for (PsiField field : psiClass.getFields()) {
                    ContainerUtil.addIfNotNull(fieldNames, field.getName());
                }
                final MultiMap result = new MultiMap();
                JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

                    @Override
                    public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
                        PsiElement target;
                        super.visitAssignmentExpression(assignment);
                        PsiExpression lExpression = assignment.getLExpression();
                        PsiExpression rExpression = assignment.getRExpression();
                        if (rExpression != null && lExpression instanceof PsiReferenceExpression && fieldNames.contains(((PsiReferenceExpression)lExpression).getReferenceName()) && (target = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiField && ((PsiField)target).getContainingClass() == psiClass) {
                            result.putValue((PsiField)target, rExpression);
                        }
                    }
                };
                for (PsiMethod constructor : psiClass.getConstructors()) {
                    if (!constructor.getLanguage().isKindOf(JavaLanguage.INSTANCE)) continue;
                    constructor.accept(visitor);
                }
                return CachedValueProvider.Result.create(result, psiClass);
            }
        });
    }

    @Nullable
    public static PsiCodeBlock getTopmostBlockInSameClass(@NotNull PsiElement position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getTopmostBlockInSameClass"));
        }
        PsiCodeBlock block = PsiTreeUtil.getParentOfType(position, PsiCodeBlock.class, false, PsiMember.class, PsiFile.class, PsiLambdaExpression.class);
        if (block == null) {
            return null;
        }
        PsiCodeBlock lastBlock = block;
        while ((block = PsiTreeUtil.getParentOfType((PsiElement)block, PsiCodeBlock.class, true, PsiMember.class, PsiFile.class, PsiLambdaExpression.class)) != null) {
            lastBlock = block;
        }
        return lastBlock;
    }

    @NotNull
    public static Collection<PsiExpression> getVariableAssignmentsInFile(@NotNull PsiVariable psiVariable, boolean literalsOnly, PsiElement place) {
        if (psiVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getVariableAssignmentsInFile"));
        }
        Ref<Boolean> modificationRef = Ref.create(Boolean.FALSE);
        PsiCodeBlock codeBlock = place == null ? null : DfaPsiUtil.getTopmostBlockInSameClass(place);
        int placeOffset = codeBlock != null ? place.getTextRange().getStartOffset() : 0;
        List<PsiExpression> list = ContainerUtil.mapNotNull(ReferencesSearch.search(psiVariable, new LocalSearchScope(new PsiElement[]{psiVariable.getContainingFile()}, null, true)).findAll(), psiReference -> {
            if (((Boolean)modificationRef.get()).booleanValue()) {
                return null;
            }
            PsiElement parent = psiReference.getElement().getParent();
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                IElementType operation = assignmentExpression.getOperationTokenType();
                if (assignmentExpression.getLExpression() == psiReference) {
                    if (JavaTokenType.EQ.equals(operation)) {
                        PsiExpression rValue = assignmentExpression.getRExpression();
                        if (!literalsOnly || DfaPsiUtil.allOperandsAreLiterals(rValue)) {
                            if (codeBlock != null && PsiTreeUtil.isAncestor(codeBlock, parent, true) && placeOffset < parent.getTextRange().getStartOffset()) {
                                return null;
                            }
                            return rValue;
                        }
                        modificationRef.set(Boolean.TRUE);
                    } else if (JavaTokenType.PLUSEQ.equals(operation)) {
                        modificationRef.set(Boolean.TRUE);
                    }
                }
            }
            return null;
        });
        if (modificationRef.get().booleanValue()) {
            List<PsiExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getVariableAssignmentsInFile"));
            }
            return list2;
        }
        PsiExpression initializer = psiVariable.getInitializer();
        if (initializer != null && (!literalsOnly || DfaPsiUtil.allOperandsAreLiterals(initializer))) {
            list = ContainerUtil.concat(list, Collections.singletonList(initializer));
        }
        List<PsiExpression> list3 = list;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getVariableAssignmentsInFile"));
        }
        return list3;
    }

    public static boolean allOperandsAreLiterals(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof PsiLiteralExpression) {
            return true;
        }
        if (expression instanceof PsiPolyadicExpression) {
            Stack<PsiExpression> stack = new Stack<PsiExpression>();
            stack.add(expression);
            while (!stack.isEmpty()) {
                PsiExpression psiExpression = (PsiExpression)stack.pop();
                if (psiExpression instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)psiExpression;
                    for (PsiExpression op : binaryExpression.getOperands()) {
                        stack.push(op);
                    }
                    continue;
                }
                if (psiExpression instanceof PsiLiteralExpression) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

