/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class AnnotateOverriddenMethodParameterFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.AnnotateMethodFix");
    private final String myAnnotation;
    private final String[] myAnnosToRemove;

    public AnnotateOverriddenMethodParameterFix(String fqn, String ... annosToRemove) {
        this.myAnnotation = fqn;
        this.myAnnosToRemove = annosToRemove;
    }

    @Override
    @NotNull
    public String getName() {
        String string = InspectionsBundle.message("annotate.overridden.methods.parameters", ClassUtil.extractClassName(this.myAnnotation));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/AnnotateOverriddenMethodParameterFix", "getName"));
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/nullable/AnnotateOverriddenMethodParameterFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/nullable/AnnotateOverriddenMethodParameterFix", "applyFix"));
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiParameter parameter = PsiTreeUtil.getParentOfType(psiElement, PsiParameter.class, false);
        if (parameter == null) {
            return;
        }
        PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiMethod.class);
        if (method == null) {
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        int index = ArrayUtilRt.find(parameters, parameter);
        ArrayList<PsiParameter> toAnnotate = new ArrayList<PsiParameter>();
        PsiMethod[] methods = OverridingMethodsSearch.search(method).toArray((PsiMethod[])PsiMethod.EMPTY_ARRAY);
        for (PsiMethod psiMethod : methods) {
            PsiParameter psiParameter;
            PsiParameter[] psiParameters = psiMethod.getParameterList().getParameters();
            if (index >= psiParameters.length || AnnotationUtil.isAnnotated((PsiModifierListOwner)(psiParameter = psiParameters[index]), this.myAnnotation, false, false) || !psiMethod.getManager().isInProject(psiMethod)) continue;
            toAnnotate.add(psiParameter);
        }
        FileModificationService.getInstance().preparePsiElementsForWrite(toAnnotate);
        for (PsiParameter psiParam : toAnnotate) {
            try {
                assert (psiParam != null) : toAnnotate;
                if (!AnnotationUtil.isAnnotatingApplicable(psiParam, this.myAnnotation)) continue;
                AddAnnotationPsiFix fix = new AddAnnotationPsiFix(this.myAnnotation, psiParam, PsiNameValuePair.EMPTY_ARRAY, this.myAnnosToRemove);
                fix.invoke(project, psiParam.getContainingFile(), psiParam, psiParam);
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message("annotate.overridden.methods.parameters.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/AnnotateOverriddenMethodParameterFix", "getFamilyName"));
        }
        return string;
    }
}

