/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.suspiciousNameCombination;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousNameCombinationInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @NonNls
    private static final String ELEMENT_GROUPS = "group";
    @NonNls
    private static final String ATTRIBUTE_NAMES = "names";
    protected final List<String> myNameGroups = new ArrayList<String>();
    private final Map<String, String> myWordToGroupMap = new HashMap<String, String>();

    public SuspiciousNameCombinationInspectionBase() {
        this.addNameGroup("x,width,left,right");
        this.addNameGroup("y,height,top,bottom");
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    protected void clearNameGroups() {
        this.myNameGroups.clear();
        this.myWordToGroupMap.clear();
    }

    protected void addNameGroup(@NonNls String group) {
        this.myNameGroups.add(group);
        List<String> words = StringUtil.split(group, ",");
        for (String word : words) {
            this.myWordToGroupMap.put(word.trim().toLowerCase(), group);
        }
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("suspicious.name.combination.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    @NonNls
    public String getShortName() {
        if ("SuspiciousNameCombination" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "getShortName"));
        }
        return "SuspiciousNameCombination";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "buildVisitor"));
        }
        MyVisitor myVisitor = new MyVisitor(holder);
        if (myVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "buildVisitor"));
        }
        return myVisitor;
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "readSettings"));
        }
        this.clearNameGroups();
        for (Object o : node.getChildren(ELEMENT_GROUPS)) {
            Element e = (Element)o;
            this.addNameGroup(e.getAttributeValue(ATTRIBUTE_NAMES));
        }
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "writeSettings"));
        }
        for (String group : this.myNameGroups) {
            Element e = new Element(ELEMENT_GROUPS);
            node.addContent(e);
            e.setAttribute(ATTRIBUTE_NAMES, group);
        }
    }

    private class MyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myProblemsHolder;

        public MyVisitor(ProblemsHolder problemsHolder) {
            this.myProblemsHolder = problemsHolder;
        }

        @Override
        public void visitVariable(PsiVariable variable) {
            PsiExpression expr;
            if (variable.hasInitializer() && (expr = variable.getInitializer()) instanceof PsiReferenceExpression) {
                PsiReferenceExpression refExpr = (PsiReferenceExpression)expr;
                PsiIdentifier nameIdentifier = variable.getNameIdentifier();
                this.checkCombination(nameIdentifier != null ? nameIdentifier : variable, variable.getName(), refExpr.getReferenceName(), "suspicious.name.assignment");
            }
        }

        @Override
        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            PsiExpression lhs = expression.getLExpression();
            PsiExpression rhs = expression.getRExpression();
            if (lhs instanceof PsiReferenceExpression && rhs instanceof PsiReferenceExpression) {
                PsiReferenceExpression lhsExpr = (PsiReferenceExpression)lhs;
                PsiReferenceExpression rhsExpr = (PsiReferenceExpression)rhs;
                this.checkCombination(lhsExpr, lhsExpr.getReferenceName(), rhsExpr.getReferenceName(), "suspicious.name.assignment");
            }
        }

        @Override
        public void visitCallExpression(PsiCallExpression expression) {
            PsiMethod psiMethod = expression.resolveMethod();
            PsiExpressionList argList = expression.getArgumentList();
            if (psiMethod != null && argList != null) {
                PsiExpression[] args = argList.getExpressions();
                PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                for (int i = 0; i < parameters.length && i < args.length; ++i) {
                    String refName;
                    if (!(args[i] instanceof PsiReferenceExpression) || this.findNameGroup(refName = ((PsiReferenceExpression)args[i]).getReferenceName()) == null) continue;
                    this.checkCombination(args[i], parameters[i].getName(), refName, "suspicious.name.parameter");
                }
            }
        }

        @Override
        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiExpression returnValue = statement.getReturnValue();
            PsiMethod containingMethod = PsiTreeUtil.getParentOfType((PsiElement)returnValue, PsiMethod.class, true, PsiLambdaExpression.class);
            if (returnValue instanceof PsiReferenceExpression && containingMethod != null) {
                String refName = ((PsiReferenceExpression)returnValue).getReferenceName();
                this.checkCombination(returnValue, containingMethod.getName(), refName, "suspicious.name.return");
            }
        }

        private void checkCombination(PsiElement location, @Nullable String name, @Nullable String referenceName, String key) {
            String nameGroup1 = this.findNameGroup(name);
            String nameGroup2 = this.findNameGroup(referenceName);
            if (nameGroup1 != null && nameGroup2 != null && !nameGroup1.equals(nameGroup2)) {
                this.myProblemsHolder.registerProblem(location, JavaErrorMessages.message(key, referenceName, name), new LocalQuickFix[0]);
            }
        }

        @Nullable
        private String findNameGroup(@Nullable String name) {
            if (name == null) {
                return null;
            }
            String[] words = NameUtil.splitNameIntoWords(name);
            String result = null;
            for (String word : words) {
                String group = (String)SuspiciousNameCombinationInspectionBase.this.myWordToGroupMap.get(word.toLowerCase());
                if (group == null) continue;
                if (result == null) {
                    result = group;
                    continue;
                }
                if (result.equals(group)) continue;
                result = null;
                break;
            }
            return result;
        }
    }
}

