/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewFactory;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeBasedStructureViewBuilder
implements StructureViewBuilder {
    @NotNull
    public abstract StructureViewModel createStructureViewModel(@Nullable Editor var1);

    @Override
    @NotNull
    public StructureView createStructureView(FileEditor fileEditor, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/structureView/TreeBasedStructureViewBuilder", "createStructureView"));
        }
        final StructureViewModel model = this.createStructureViewModel(fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null);
        StructureView view = StructureViewFactory.getInstance(project).createStructureView(fileEditor, model, project, this.isRootNodeShown());
        Disposer.register(view, new Disposable(){

            @Override
            public void dispose() {
                model.dispose();
            }
        });
        StructureView structureView = view;
        if (structureView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/TreeBasedStructureViewBuilder", "createStructureView"));
        }
        return structureView;
    }

    public boolean isRootNodeShown() {
        return true;
    }
}

