/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaFileTreeElement
extends PsiTreeElementBase<PsiClassOwner>
implements ItemPresentation {
    public JavaFileTreeElement(PsiClassOwner file) {
        super(file);
    }

    @Override
    public String getPresentableText() {
        PsiClassOwner element = (PsiClassOwner)this.getElement();
        return element == null ? "" : element.getName();
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        PsiClassOwner element = (PsiClassOwner)this.getElement();
        if (element == null) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/JavaFileTreeElement", "getChildrenBase"));
            }
            return list;
        }
        PsiClass[] classes = element.getClasses();
        ArrayList<StructureViewTreeElement> result = new ArrayList<StructureViewTreeElement>();
        for (PsiClass aClass : classes) {
            result.add(new JavaClassTreeElement(aClass, false, new HashSet<PsiClass>()));
        }
        ArrayList<StructureViewTreeElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/JavaFileTreeElement", "getChildrenBase"));
        }
        return arrayList;
    }
}

