/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.dtd;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.xml.XMLParserDefinition;
import com.intellij.lexer.DtdLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.parsing.xml.DtdParsing;
import com.intellij.psi.impl.source.xml.XmlFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import org.jetbrains.annotations.NotNull;

public class DTDParserDefinition
extends XMLParserDefinition {
    @Override
    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return LanguageUtil.canStickTokensTogetherByLexer(left, right, new DtdLexer(false));
    }

    @Override
    public PsiFile createFile(FileViewProvider viewProvider) {
        return new XmlFileImpl(viewProvider, XmlElementType.DTD_FILE);
    }

    @Override
    @NotNull
    public PsiParser createParser(Project project) {
        PsiParser psiParser = new PsiParser(){

            @Override
            @NotNull
            public ASTNode parse(IElementType root, PsiBuilder builder) {
                ASTNode aSTNode = new DtdParsing(root, XmlEntityDecl.EntityContextType.GENERIC_XML, builder).parse();
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/dtd/DTDParserDefinition$1", "parse"));
                }
                return aSTNode;
            }
        };
        if (psiParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/dtd/DTDParserDefinition", "createParser"));
        }
        return psiParser;
    }

    @Override
    public IFileElementType getFileNodeType() {
        return XmlElementType.DTD_FILE;
    }

    @Override
    @NotNull
    public Lexer createLexer(Project project) {
        DtdLexer dtdLexer = new DtdLexer(false);
        if (dtdLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/dtd/DTDParserDefinition", "createLexer"));
        }
        return dtdLexer;
    }
}

