/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html.structureView;

import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.smartTree.TreeStructureUtil;
import com.intellij.lang.html.structureView.HtmlTagTreeElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.XmlTagFilter;
import com.intellij.psi.scope.processor.FilterElementProcessor;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HtmlFileTreeElement
extends PsiTreeElementBase<XmlFile> {
    private final boolean myInStructureViewPopup;

    public HtmlFileTreeElement(boolean inStructureViewPopup, XmlFile xmlFile) {
        super(xmlFile);
        this.myInStructureViewPopup = inStructureViewPopup;
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        XmlDocument document;
        if (this.isHtml5SectionsMode()) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/HtmlFileTreeElement", "getChildrenBase"));
            }
            return list;
        }
        XmlFile xmlFile = (XmlFile)this.getElement();
        XmlDocument xmlDocument = document = xmlFile == null ? null : xmlFile.getDocument();
        if (document == null) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/HtmlFileTreeElement", "getChildrenBase"));
            }
            return list;
        }
        SmartList rootTags = new SmartList();
        document.processElements(new FilterElementProcessor((ElementFilter)XmlTagFilter.INSTANCE, rootTags), document);
        if (rootTags.isEmpty()) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/HtmlFileTreeElement", "getChildrenBase"));
            }
            return list;
        }
        if (rootTags.size() == 1) {
            XmlTag rootTag = (XmlTag)rootTags.get(0);
            if ("html".equalsIgnoreCase(rootTag.getLocalName())) {
                XmlTag[] subTags = rootTag.getSubTags();
                if (subTags.length == 1 && ("head".equalsIgnoreCase(subTags[0].getLocalName()) || "body".equalsIgnoreCase(subTags[0].getLocalName()))) {
                    Collection<StructureViewTreeElement> collection = new HtmlTagTreeElement(subTags[0]).getChildrenBase();
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/HtmlFileTreeElement", "getChildrenBase"));
                    }
                    return collection;
                }
                Collection<StructureViewTreeElement> collection = new HtmlTagTreeElement(rootTag).getChildrenBase();
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/HtmlFileTreeElement", "getChildrenBase"));
                }
                return collection;
            }
            List<StructureViewTreeElement> list = Collections.singletonList(new HtmlTagTreeElement(rootTag));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/HtmlFileTreeElement", "getChildrenBase"));
            }
            return list;
        }
        ArrayList<StructureViewTreeElement> result = new ArrayList<StructureViewTreeElement>(rootTags.size());
        for (XmlTag tag : rootTags) {
            result.add(new HtmlTagTreeElement(tag));
        }
        ArrayList<StructureViewTreeElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/HtmlFileTreeElement", "getChildrenBase"));
        }
        return arrayList;
    }

    private boolean isHtml5SectionsMode() {
        XmlFile xmlFile = (XmlFile)this.getElement();
        if (xmlFile == null) {
            return false;
        }
        if (this.myInStructureViewPopup) {
            String propertyName = TreeStructureUtil.getPropertyName("html5.sections.node.provider");
            if (PropertiesComponent.getInstance().getBoolean(propertyName)) {
                return true;
            }
        } else if (StructureViewFactoryEx.getInstanceEx(xmlFile.getProject()).isActionActive("HTML5_OUTLINE_MODE")) {
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getPresentableText() {
        return this.toString();
    }
}

