/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.lang.LangBundle;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class XmlFindUsagesProvider
implements FindUsagesProvider {
    @Override
    public boolean canFindUsagesFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/xml/XmlFindUsagesProvider", "canFindUsagesFor"));
        }
        return element instanceof XmlElementDecl || element instanceof XmlAttributeDecl || element instanceof XmlEntityDecl || element instanceof XmlTag || element instanceof XmlAttributeValue || element instanceof PsiFile || element instanceof XmlComment;
    }

    @Override
    @NotNull
    public String getType(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
        }
        if (element instanceof XmlTag) {
            PsiMetaData metaData = ((XmlTag)element).getMetaData();
            if (metaData != null && metaData.getDeclaration() instanceof XmlTag) {
                String string = ((XmlTag)metaData.getDeclaration()).getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
                }
                return string;
            }
            String string = LangBundle.message("xml.terms.xml.tag", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof XmlElementDecl) {
            String string = LangBundle.message("xml.terms.tag", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof XmlAttributeDecl) {
            String string = LangBundle.message("xml.terms.attribute", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof XmlAttributeValue) {
            String string = LangBundle.message("xml.terms.attribute.value", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof XmlEntityDecl) {
            String string = LangBundle.message("xml.terms.entity", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof XmlAttribute) {
            String string = LangBundle.message("xml.terms.attribute", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof XmlComment) {
            String string = LangBundle.message("xml.terms.variable", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
            }
            return string;
        }
        throw new IllegalArgumentException("Cannot get type for " + element);
    }

    @Override
    public String getHelpId(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/xml/XmlFindUsagesProvider", "getHelpId"));
        }
        return "reference.dialogs.findUsages.other";
    }

    @Override
    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/xml/XmlFindUsagesProvider", "getDescriptiveName"));
        }
        if (element instanceof XmlTag) {
            String string = ((XmlTag)element).getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof XmlAttributeValue) {
            String string = ((XmlAttributeValue)element).getValue();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PsiNamedElement) {
            String string = ((PsiNamedElement)element).getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getDescriptiveName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/xml/XmlFindUsagesProvider", "getNodeText"));
        }
        if (element instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)element;
            PsiMetaData metaData = xmlTag.getMetaData();
            String name = metaData != null ? DescriptiveNameUtil.getMetaDataName(metaData) : xmlTag.getName();
            String presentableName = metaData == null ? "<" + name + ">" : name;
            String string = presentableName + " of file " + xmlTag.getContainingFile().getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        if (element instanceof XmlAttributeValue) {
            String string = ((XmlAttributeValue)element).getValue();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        if (element instanceof PsiNamedElement) {
            String string = ((PsiNamedElement)element).getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getNodeText"));
        }
        return string;
    }

    @Override
    public WordsScanner getWordsScanner() {
        return null;
    }
}

