/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataKey<T> {
    private static final Map<String, DataKey> ourDataKeyIndex = new HashMap<String, DataKey>();
    private final String myName;

    private DataKey(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/actionSystem/DataKey", "<init>"));
        }
        this.myName = name;
    }

    public static <T> DataKey<T> create(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/actionSystem/DataKey", "create"));
        }
        DataKey<T> key = ourDataKeyIndex.get(name);
        if (key != null) {
            return key;
        }
        key = new DataKey<T>(name);
        ourDataKeyIndex.put(name, key);
        return key;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/DataKey", "getName"));
        }
        return string;
    }

    public final boolean is(String dataId) {
        return this.myName.equals(dataId);
    }

    @Nullable
    public T getData(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/actionSystem/DataKey", "getData"));
        }
        return (T)dataContext.getData(this.myName);
    }

    @Nullable
    public T getData(@NotNull DataProvider dataProvider) {
        if (dataProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/intellij/openapi/actionSystem/DataKey", "getData"));
        }
        return (T)dataProvider.getData(this.myName);
    }
}

