/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.util.Comparing;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KeyboardShortcut
extends Shortcut {
    private final KeyStroke myFirstKeyStroke;
    private final KeyStroke mySecondKeyStroke;

    public KeyboardShortcut(@NotNull KeyStroke firstKeyStroke, @Nullable KeyStroke secondKeyStroke) {
        if (firstKeyStroke == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstKeyStroke", "com/intellij/openapi/actionSystem/KeyboardShortcut", "<init>"));
        }
        this.myFirstKeyStroke = firstKeyStroke;
        this.mySecondKeyStroke = secondKeyStroke;
    }

    @NotNull
    public KeyStroke getFirstKeyStroke() {
        KeyStroke keyStroke = this.myFirstKeyStroke;
        if (keyStroke == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/KeyboardShortcut", "getFirstKeyStroke"));
        }
        return keyStroke;
    }

    @Nullable
    public KeyStroke getSecondKeyStroke() {
        return this.mySecondKeyStroke;
    }

    public int hashCode() {
        int hashCode = this.myFirstKeyStroke.hashCode();
        if (this.mySecondKeyStroke != null) {
            hashCode += this.mySecondKeyStroke.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyboardShortcut)) {
            return false;
        }
        KeyboardShortcut second = (KeyboardShortcut)obj;
        return Comparing.equal(this.myFirstKeyStroke, second.myFirstKeyStroke) && Comparing.equal(this.mySecondKeyStroke, second.mySecondKeyStroke);
    }

    @Override
    public boolean isKeyboard() {
        return true;
    }

    @Override
    public boolean startsWith(Shortcut sc) {
        if (sc instanceof KeyboardShortcut) {
            KeyboardShortcut other = (KeyboardShortcut)sc;
            return this.myFirstKeyStroke.equals(other.myFirstKeyStroke) && (other.mySecondKeyStroke == null || other.mySecondKeyStroke.equals(this.mySecondKeyStroke));
        }
        return false;
    }

    public static KeyboardShortcut fromString(@NonNls String s) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(s);
        assert (keyStroke != null) : "Can't create key stroke for " + s;
        return new KeyboardShortcut(keyStroke, null);
    }

    public String toString() {
        return this.mySecondKeyStroke == null ? "[" + this.myFirstKeyStroke + "]" : "[" + this.myFirstKeyStroke + "]+[" + this.mySecondKeyStroke + "]";
    }
}

