/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ComponentConfig {
    public static final ComponentConfig[] EMPTY_ARRAY = new ComponentConfig[0];
    protected String implementationClass;
    protected String interfaceClass;
    protected String headlessImplementationClass;
    protected boolean loadForDefaultProject;
    @Property(surroundWithTag=false)
    @MapAnnotation(surroundWithTag=false, entryTagName="option", keyAttributeName="name", valueAttributeName="value")
    @Nullable
    public Map<String, String> options;
    @Transient
    public PluginDescriptor pluginDescriptor;

    @Transient
    public ClassLoader getClassLoader() {
        return this.pluginDescriptor != null ? this.pluginDescriptor.getPluginClassLoader() : this.getClass().getClassLoader();
    }

    @Transient
    public PluginId getPluginId() {
        return this.pluginDescriptor == null ? null : this.pluginDescriptor.getPluginId();
    }

    public String getImplementationClass() {
        return this.implementationClass;
    }

    public String getInterfaceClass() {
        return this.interfaceClass;
    }

    public String getHeadlessImplementationClass() {
        return this.headlessImplementationClass;
    }

    public boolean isLoadForDefaultProject() {
        return this.loadForDefaultProject;
    }

    public boolean prepareClasses(boolean headless) {
        if (headless && this.headlessImplementationClass != null) {
            if (StringUtil.isEmpty(this.headlessImplementationClass)) {
                return false;
            }
            this.setImplementationClass(this.headlessImplementationClass);
        }
        if (StringUtil.isEmpty(this.interfaceClass)) {
            this.setInterfaceClass(this.implementationClass);
        }
        return true;
    }

    public void setImplementationClass(String implementationClass) {
        this.implementationClass = implementationClass == null ? null : implementationClass.trim();
    }

    public void setInterfaceClass(String interfaceClass) {
        this.interfaceClass = interfaceClass == null ? null : interfaceClass.trim();
    }

    public void setHeadlessImplementationClass(String headlessImplementationClass) {
        String string = headlessImplementationClass = headlessImplementationClass == null ? null : headlessImplementationClass.trim();
        this.headlessImplementationClass = headlessImplementationClass == null ? null : (StringUtil.isEmpty(headlessImplementationClass) ? "" : headlessImplementationClass);
    }

    public void setLoadForDefaultProject(boolean loadForDefaultProject) {
        this.loadForDefaultProject = loadForDefaultProject;
    }

    public String toString() {
        return "ComponentConfig{implementationClass='" + this.implementationClass + '\'' + ", interfaceClass='" + this.interfaceClass + '\'' + ", headlessImplementationClass='" + this.headlessImplementationClass + '\'' + ", loadForDefaultProject=" + this.loadForDefaultProject + ", options=" + this.options + ", pluginDescriptor=" + this.pluginDescriptor + '}';
    }
}

