/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.ex;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DefaultColorSchemesManager", defaultStateAsResource=true, storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
public class DefaultColorSchemesManager
implements PersistentStateComponent<Element> {
    private final List<DefaultColorsScheme> mySchemes = new ArrayList<DefaultColorsScheme>();
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";

    public static DefaultColorSchemesManager getInstance() {
        return ServiceManager.getService(DefaultColorSchemesManager.class);
    }

    @Override
    @Nullable
    public Element getState() {
        return null;
    }

    @Override
    public void loadState(Element state) {
        for (Element schemeElement : state.getChildren(SCHEME_ELEMENT)) {
            boolean isUpdated = false;
            Attribute nameAttr = schemeElement.getAttribute("name");
            if (nameAttr != null) {
                for (DefaultColorsScheme oldScheme : this.mySchemes) {
                    if (!StringUtil.equals(nameAttr.getValue(), oldScheme.getName())) continue;
                    oldScheme.readExternal(schemeElement);
                    isUpdated = true;
                }
            }
            if (isUpdated) continue;
            DefaultColorsScheme newScheme = new DefaultColorsScheme();
            newScheme.readExternal(schemeElement);
            this.mySchemes.add(newScheme);
        }
        this.mySchemes.add(EmptyColorScheme.INSTANCE);
    }

    @NotNull
    public DefaultColorsScheme[] getAllSchemes() {
        DefaultColorsScheme[] defaultColorsSchemeArray = this.mySchemes.toArray(new DefaultColorsScheme[this.mySchemes.size()]);
        if (defaultColorsSchemeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/ex/DefaultColorSchemesManager", "getAllSchemes"));
        }
        return defaultColorsSchemeArray;
    }

    @NotNull
    public DefaultColorsScheme getFirstScheme() {
        DefaultColorsScheme defaultColorsScheme = this.mySchemes.get(0);
        if (defaultColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/ex/DefaultColorSchemesManager", "getFirstScheme"));
        }
        return defaultColorsScheme;
    }

    @Nullable
    public EditorColorsScheme getScheme(String name) {
        for (DefaultColorsScheme scheme : this.mySchemes) {
            if (!name.equals(scheme.getName())) continue;
            return scheme;
        }
        return null;
    }
}

