/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectUtilCore {
    public static String displayUrlRelativeToProject(@NotNull VirtualFile file, @NotNull String url, @NotNull Project project, boolean includeFilePath, boolean keepModuleAlwaysOnTheLeft) {
        Module module;
        VirtualFile fileForJar;
        String projectHomeUrl;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/project/ProjectUtilCore", "displayUrlRelativeToProject"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/project/ProjectUtilCore", "displayUrlRelativeToProject"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/ProjectUtilCore", "displayUrlRelativeToProject"));
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null && includeFilePath && url.startsWith(projectHomeUrl = baseDir.getPresentableUrl())) {
            url = "..." + url.substring(projectHomeUrl.length());
        }
        if (SystemInfo.isMac && file.getFileSystem() instanceof LocalFileProvider && (fileForJar = ((LocalFileProvider)((Object)file.getFileSystem())).getLocalVirtualFileFor(file)) != null) {
            OrderEntry libraryEntry = LibraryUtil.findLibraryEntry(file, project);
            url = libraryEntry != null ? (libraryEntry instanceof JdkOrderEntry ? url + " - [" + ((JdkOrderEntry)libraryEntry).getJdkName() + "]" : url + " - [" + libraryEntry.getPresentableName() + "]") : url + " - [" + fileForJar.getName() + "]";
        }
        if ((module = ModuleUtilCore.findModuleForFile(file, project)) == null) {
            return url;
        }
        return !keepModuleAlwaysOnTheLeft && SystemInfo.isMac ? url + " - [" + module.getName() + "]" : "[" + module.getName() + "] - " + url;
    }

    @Nullable
    public static String getPresentableName(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/ProjectUtilCore", "getPresentableName"));
        }
        if (project.isDefault()) {
            return project.getName();
        }
        String location = project.getPresentableUrl();
        if (location == null) {
            return null;
        }
        String projectName = FileUtil.toSystemIndependentName(location);
        int lastSlash = (projectName = StringUtil.trimEnd(projectName, "/")).lastIndexOf(47);
        if (lastSlash >= 0 && lastSlash + 1 < projectName.length()) {
            projectName = projectName.substring(lastSlash + 1);
        }
        if (StringUtil.endsWithIgnoreCase(projectName, ".ipr")) {
            projectName = projectName.substring(0, projectName.length() - ".ipr".length());
        }
        projectName = projectName.toLowerCase(Locale.US).replace(':', '_');
        return projectName;
    }
}

