/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleOrderEnumerator
extends OrderEnumeratorBase {
    private final ModuleRootModel myRootModel;

    public ModuleOrderEnumerator(ModuleRootModel rootModel, OrderRootsCache cache) {
        super(cache);
        this.myRootModel = rootModel;
    }

    @Override
    public void processRootModules(@NotNull Processor<Module> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/ModuleOrderEnumerator", "processRootModules"));
        }
        processor.process(this.myRootModel.getModule());
    }

    @Override
    protected void forEach(@NotNull PairProcessor<OrderEntry, List<OrderEnumerationHandler>> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/ModuleOrderEnumerator", "forEach"));
        }
        this.processEntries(this.myRootModel, processor, (Set<Module>)(this.myRecursively ? new THashSet() : null), true, ModuleOrderEnumerator.getCustomHandlers(this.myRootModel.getModule()));
    }

    @Override
    public boolean isRootModuleModel(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/ModuleOrderEnumerator", "isRootModuleModel"));
        }
        return rootModel.equals(this.myRootModel);
    }
}

