/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.ApplicationLibraryTable;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LibraryTablesRegistrarImpl
extends LibraryTablesRegistrar
implements Disposable {
    private static final Map<String, LibraryTable> myLibraryTables = new HashMap<String, LibraryTable>();

    @Override
    @NotNull
    public LibraryTable getLibraryTable() {
        ApplicationLibraryTable applicationLibraryTable = ApplicationLibraryTable.getApplicationTable();
        if (applicationLibraryTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl", "getLibraryTable"));
        }
        return applicationLibraryTable;
    }

    @Override
    @NotNull
    public LibraryTable getLibraryTable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl", "getLibraryTable"));
        }
        LibraryTable libraryTable = ProjectLibraryTable.getInstance(project);
        if (libraryTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl", "getLibraryTable"));
        }
        return libraryTable;
    }

    @Override
    public LibraryTable getLibraryTableByLevel(String level, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl", "getLibraryTableByLevel"));
        }
        if ("project".equals(level)) {
            return this.getLibraryTable(project);
        }
        if ("application".equals(level)) {
            return this.getLibraryTable();
        }
        return myLibraryTables.get(level);
    }

    @Override
    public void registerLibraryTable(@NotNull LibraryTable libraryTable) {
        if (libraryTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryTable", "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl", "registerLibraryTable"));
        }
        String tableLevel = libraryTable.getTableLevel();
        LibraryTable oldTable = myLibraryTables.put(tableLevel, libraryTable);
        if (oldTable != null) {
            throw new IllegalArgumentException("Library table '" + tableLevel + "' already registered.");
        }
    }

    @Override
    public List<LibraryTable> getCustomLibraryTables() {
        return new SmartList<LibraryTable>(myLibraryTables.values());
    }

    @Override
    public void dispose() {
        myLibraryTables.clear();
    }
}

