/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarHandler;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJarVirtualFile
extends VirtualFile {
    private final CoreJarHandler myHandler;
    private final String myName;
    private final FileAttributes myEntry;
    private final VirtualFile myParent;
    private List<VirtualFile> myChildren;

    public CoreJarVirtualFile(@NotNull CoreJarHandler handler, @NotNull String name, @NotNull FileAttributes entry, @Nullable CoreJarVirtualFile parent) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "<init>"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "<init>"));
        }
        this.myChildren = null;
        this.myHandler = handler;
        this.myName = name;
        this.myEntry = entry;
        this.myParent = parent;
        if (parent != null) {
            if (parent.myChildren == null) {
                parent.myChildren = new SmartList<VirtualFile>();
            }
            parent.myChildren.add(this);
        }
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        CoreJarFileSystem coreJarFileSystem = this.myHandler.getFileSystem();
        if (coreJarFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "getFileSystem"));
        }
        return coreJarFileSystem;
    }

    @Override
    @NotNull
    public String getPath() {
        if (this.myParent == null) {
            String string = FileUtil.toSystemIndependentName(this.myHandler.getFile().getPath()) + "!/";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "getPath"));
            }
            return string;
        }
        String parentPath = this.myParent.getPath();
        StringBuilder answer = new StringBuilder(parentPath.length() + 1 + this.myName.length());
        answer.append(parentPath);
        if (answer.charAt(answer.length() - 1) != '/') {
            answer.append('/');
        }
        answer.append(this.myName);
        String string = answer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "getPath"));
        }
        return string;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.myEntry.isDirectory();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public VirtualFile getParent() {
        return this.myParent;
    }

    @Override
    public VirtualFile[] getChildren() {
        if (this.myChildren == null) {
            return VirtualFile.EMPTY_ARRAY;
        }
        return this.myChildren.toArray(new VirtualFile[this.myChildren.size()]);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        Couple<String> pair = ((CoreJarFileSystem)this.getFileSystem()).splitPath(this.getPath());
        byte[] byArray = this.myHandler.contentsToByteArray((String)pair.second);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "contentsToByteArray"));
        }
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        return this.myEntry.lastModified;
    }

    @Override
    public long getLength() {
        return this.myEntry.length;
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferExposingByteArrayInputStream(this.contentsToByteArray());
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }
}

