/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.xml.impl.events;

import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.events.XmlTagChildChanged;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;

public class XmlTagChildChangedImpl
implements XmlTagChildChanged {
    private final XmlTag myTag;
    private final XmlTagChild myChild;

    public XmlTagChildChangedImpl(XmlTag context, XmlTagChild treeElement) {
        this.myTag = context;
        this.myChild = treeElement;
    }

    @Override
    public XmlTag getTag() {
        return this.myTag;
    }

    @Override
    public XmlTagChild getChild() {
        return this.myChild;
    }

    public static PomModelEvent createXmlTagChildChanged(PomModel source, XmlTag context, XmlTagChild treeElement) {
        PomModelEvent event = new PomModelEvent(source);
        XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(source, PsiTreeUtil.getParentOfType((PsiElement)context, XmlFile.class));
        xmlAspectChangeSet.add(new XmlTagChildChangedImpl(context, treeElement));
        event.registerChangeSet(source.getModelAspect(XmlAspect.class), xmlAspectChangeSet);
        return event;
    }

    public String toString() {
        return "child changed in " + this.getTag().getName() + " child: " + this.myChild.toString();
    }
}

