/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.problems;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.Problem;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class WolfTheProblemSolver {
    public static final ExtensionPointName<Condition<VirtualFile>> FILTER_EP_NAME = ExtensionPointName.create("com.intellij.problemFileHighlightFilter");

    public static WolfTheProblemSolver getInstance(Project project) {
        return project.getComponent(WolfTheProblemSolver.class);
    }

    public abstract boolean isProblemFile(VirtualFile var1);

    public abstract void weHaveGotProblems(@NotNull VirtualFile var1, @NotNull List<Problem> var2);

    public abstract void weHaveGotNonIgnorableProblems(@NotNull VirtualFile var1, @NotNull List<Problem> var2);

    public abstract void clearProblems(@NotNull VirtualFile var1);

    public abstract boolean hasProblemFilesBeneath(@NotNull Condition<VirtualFile> var1);

    public abstract boolean hasProblemFilesBeneath(@NotNull Module var1);

    public abstract Problem convertToProblem(VirtualFile var1, int var2, int var3, String[] var4);

    public abstract void reportProblems(VirtualFile var1, Collection<Problem> var2);

    public abstract boolean hasSyntaxErrors(VirtualFile var1);

    public abstract void addProblemListener(@NotNull ProblemListener var1);

    public abstract void addProblemListener(@NotNull ProblemListener var1, @NotNull Disposable var2);

    public abstract void removeProblemListener(@NotNull ProblemListener var1);

    public abstract void registerFileHighlightFilter(@NotNull Condition<VirtualFile> var1, @NotNull Disposable var2);

    public abstract void queue(VirtualFile var1);

    public static abstract class ProblemListener {
        public void problemsAppeared(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/problems/WolfTheProblemSolver$ProblemListener", "problemsAppeared"));
            }
        }

        public void problemsChanged(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/problems/WolfTheProblemSolver$ProblemListener", "problemsChanged"));
            }
        }

        public void problemsDisappeared(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/problems/WolfTheProblemSolver$ProblemListener", "problemsDisappeared"));
            }
        }
    }
}

