/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

class HighlightingCaches {
    private final List<Map<?, ?>> allCaches;
    final ConcurrentMap<PsiClass, PsiClass[]> DIRECT_SUB_CLASSES;
    final ConcurrentMap<PsiClass, Iterable<PsiClass>> ALL_SUB_CLASSES;
    final Map<PsiMethod, Iterable<PsiMethod>> OVERRIDING_METHODS;

    public static HighlightingCaches getInstance(Project project) {
        return ServiceManager.getService(project, HighlightingCaches.class);
    }

    public HighlightingCaches(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/HighlightingCaches", "<init>"));
        }
        this.allCaches = ContainerUtil.createConcurrentList();
        this.DIRECT_SUB_CLASSES = this.createWeakCache();
        this.ALL_SUB_CLASSES = this.createWeakCache();
        this.OVERRIDING_METHODS = this.createWeakCache();
        project.getMessageBus().connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                if (isPhysical) {
                    HighlightingCaches.this.allCaches.forEach(Map::clear);
                }
            }

            @Override
            public void afterPsiChanged(boolean isPhysical) {
            }
        });
    }

    @NotNull
    private <T, V> ConcurrentMap<T, V> createWeakCache() {
        ConcurrentMap map = ContainerUtil.createConcurrentWeakKeySoftValueMap(10, 0.7f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy());
        this.allCaches.add(map);
        ConcurrentMap concurrentMap = map;
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/HighlightingCaches", "createWeakCache"));
        }
        return concurrentMap;
    }
}

