/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.todo.TodoIndexPatternProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.search.LightIndexPatternSearch;
import com.intellij.psi.impl.search.TodoItemsCreator;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.psi.search.searches.IndexPatternSearch;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiTodoSearchHelperImpl
implements PsiTodoSearchHelper {
    private final PsiManagerEx myManager;
    private static final TodoItem[] EMPTY_TODO_ITEMS = new TodoItem[0];

    public PsiTodoSearchHelperImpl(PsiManagerEx manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public PsiFile[] findFilesWithTodoItems() {
        PsiFile[] psiFileArray = TodoCacheManager.SERVICE.getInstance(this.myManager.getProject()).getFilesWithTodoItems();
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "findFilesWithTodoItems"));
        }
        return psiFileArray;
    }

    @Override
    @NotNull
    public TodoItem[] findTodoItems(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "findTodoItems"));
        }
        TodoItem[] todoItemArray = this.findTodoItems(file, 0, file.getTextLength());
        if (todoItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "findTodoItems"));
        }
        return todoItemArray;
    }

    @Override
    @NotNull
    public TodoItem[] findTodoItems(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "findTodoItems"));
        }
        Collection<IndexPatternOccurrence> occurrences = IndexPatternSearch.search(file, TodoIndexPatternProvider.getInstance()).findAll();
        if (occurrences.isEmpty()) {
            if (EMPTY_TODO_ITEMS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "findTodoItems"));
            }
            return EMPTY_TODO_ITEMS;
        }
        TodoItem[] todoItemArray = PsiTodoSearchHelperImpl.processTodoOccurences(startOffset, endOffset, occurrences);
        if (todoItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "findTodoItems"));
        }
        return todoItemArray;
    }

    @NotNull
    private static TodoItem[] processTodoOccurences(int startOffset, int endOffset, Collection<IndexPatternOccurrence> occurrences) {
        ArrayList<TodoItem> items = new ArrayList<TodoItem>(occurrences.size());
        TextRange textRange = new TextRange(startOffset, endOffset);
        TodoItemsCreator todoItemsCreator = new TodoItemsCreator();
        for (IndexPatternOccurrence occurrence : occurrences) {
            TextRange occurrenceRange = occurrence.getTextRange();
            if (!textRange.contains(occurrenceRange)) continue;
            items.add(todoItemsCreator.createTodo(occurrence));
        }
        TodoItem[] todoItemArray = items.toArray(new TodoItem[items.size()]);
        if (todoItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "processTodoOccurences"));
        }
        return todoItemArray;
    }

    @Override
    @NotNull
    public TodoItem[] findTodoItemsLight(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "findTodoItemsLight"));
        }
        TodoItem[] todoItemArray = this.findTodoItemsLight(file, 0, file.getTextLength());
        if (todoItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "findTodoItemsLight"));
        }
        return todoItemArray;
    }

    @Override
    @NotNull
    public TodoItem[] findTodoItemsLight(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "findTodoItemsLight"));
        }
        Collection<IndexPatternOccurrence> occurrences = LightIndexPatternSearch.SEARCH.createQuery(new IndexPatternSearch.SearchParameters(file, TodoIndexPatternProvider.getInstance())).findAll();
        if (occurrences.isEmpty()) {
            if (EMPTY_TODO_ITEMS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "findTodoItemsLight"));
            }
            return EMPTY_TODO_ITEMS;
        }
        TodoItem[] todoItemArray = PsiTodoSearchHelperImpl.processTodoOccurences(startOffset, endOffset, occurrences);
        if (todoItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "findTodoItemsLight"));
        }
        return todoItemArray;
    }

    @Override
    public int getTodoItemsCount(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "getTodoItemsCount"));
        }
        int count = TodoCacheManager.SERVICE.getInstance(this.myManager.getProject()).getTodoCount(file.getVirtualFile(), TodoIndexPatternProvider.getInstance());
        if (count != -1) {
            return count;
        }
        return this.findTodoItems(file).length;
    }

    @Override
    public int getTodoItemsCount(@NotNull PsiFile file, @NotNull TodoPattern pattern) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "getTodoItemsCount"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl", "getTodoItemsCount"));
        }
        int count = TodoCacheManager.SERVICE.getInstance(this.myManager.getProject()).getTodoCount(file.getVirtualFile(), pattern.getIndexPattern());
        if (count != -1) {
            return count;
        }
        TodoItem[] items = this.findTodoItems(file);
        count = 0;
        for (TodoItem item : items) {
            if (!item.getPattern().equals(pattern)) continue;
            ++count;
        }
        return count;
    }
}

