/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class BasicAttributeValueReference
implements PsiReference {
    protected final PsiElement myElement;
    protected final TextRange myRange;

    public BasicAttributeValueReference(PsiElement element) {
        this(element, ElementManipulators.getValueTextRange(element));
    }

    public BasicAttributeValueReference(PsiElement element, int offset) {
        this(element, new TextRange(offset, element.getTextLength() - offset));
    }

    public BasicAttributeValueReference(PsiElement element, TextRange range) {
        this.myElement = element;
        this.myRange = range;
    }

    @Override
    public PsiElement getElement() {
        return this.myElement;
    }

    @Override
    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String s = this.myElement.getText();
        if (this.myRange.getStartOffset() < s.length() && this.myRange.getEndOffset() <= s.length()) {
            String string = this.myRange.substring(s);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/BasicAttributeValueReference", "getCanonicalText"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/BasicAttributeValueReference", "getCanonicalText"));
        }
        return "";
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return ElementManipulators.getManipulator(this.myElement).handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/BasicAttributeValueReference", "bindToElement"));
        }
        return null;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return this.myElement.getManager().areElementsEquivalent(element, this.resolve());
    }
}

