/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.parsing.xml.DtdParsing;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlTokenImpl;
import com.intellij.psi.tree.xml.IXmlLeafElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementContentSpec;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEntityDeclImpl
extends XmlElementImpl
implements XmlEntityDecl,
XmlElementType {
    public XmlEntityDeclImpl() {
        super(XML_ENTITY_DECL);
    }

    @Override
    public PsiElement getNameElement() {
        for (ASTNode e = this.getFirstChildNode(); e != null; e = e.getTreeNext()) {
            XmlTokenImpl xmlToken;
            if (!(e instanceof XmlTokenImpl) || (xmlToken = (XmlTokenImpl)e).getTokenType() != XmlTokenType.XML_NAME) continue;
            return xmlToken;
        }
        return null;
    }

    @Override
    public XmlAttributeValue getValueElement() {
        if (this.isInternalReference()) {
            for (ASTNode e = this.getFirstChildNode(); e != null; e = e.getTreeNext()) {
                if (e.getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE) continue;
                return (XmlAttributeValue)SourceTreeToPsiMap.treeElementToPsi(e);
            }
        } else {
            for (ASTNode e = this.getLastChildNode(); e != null; e = e.getTreePrev()) {
                if (e.getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE) continue;
                return (XmlAttributeValue)SourceTreeToPsiMap.treeElementToPsi(e);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        PsiElement nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getText() : "";
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/xml/XmlEntityDeclImpl", "setName"));
        }
        PsiElement nameElement = this.getNameElement();
        if (nameElement != null) {
            return ElementManipulators.getManipulator(nameElement).handleContentChange(nameElement, new TextRange(0, nameElement.getTextLength()), name);
        }
        return null;
    }

    @Override
    public PsiElement parse(PsiFile baseFile, XmlEntityDecl.EntityContextType contextType, XmlEntityRef originalElement) {
        PsiElement dep = XmlElement.DEPENDING_ELEMENT.get(this.getParent());
        PsiElement dependsOnElement = this.getValueElement(dep instanceof PsiFile ? (PsiFile)dep : baseFile);
        String value = null;
        if (dependsOnElement instanceof XmlAttributeValue) {
            XmlAttributeValue attributeValue = (XmlAttributeValue)dependsOnElement;
            value = attributeValue.getValue();
        } else if (dependsOnElement instanceof PsiFile) {
            PsiFile file = (PsiFile)dependsOnElement;
            value = file.getText();
        }
        if (value == null) {
            return null;
        }
        DtdParsing dtdParsing = new DtdParsing(value, XML_ELEMENT_DECL, contextType, baseFile);
        PsiElement generated = dtdParsing.parse().getPsi().getFirstChild();
        if (contextType == XmlEntityDecl.EntityContextType.ELEMENT_CONTENT_SPEC && generated instanceof XmlElementContentSpec) {
            generated = generated.getFirstChild();
        }
        this.setDependsOnElement(generated, dependsOnElement);
        return this.setOriginalElement(generated, originalElement);
    }

    private PsiElement setDependsOnElement(PsiElement generated, PsiElement dependsOnElement) {
        for (PsiElement e = generated; e != null; e = e.getNextSibling()) {
            e.putUserData(XmlElement.DEPENDING_ELEMENT, dependsOnElement);
        }
        return generated;
    }

    private PsiElement setOriginalElement(PsiElement element, PsiElement valueElement) {
        for (PsiElement e = element; e != null; e = e.getNextSibling()) {
            e.putUserData(XmlElement.INCLUDING_ELEMENT, (XmlElement)valueElement);
        }
        return element;
    }

    @Nullable
    private PsiElement getValueElement(PsiFile baseFile) {
        String value;
        XmlAttributeValue attributeValue = this.getValueElement();
        if (this.isInternalReference()) {
            return attributeValue;
        }
        if (attributeValue != null && (value = attributeValue.getValue()) != null) {
            XmlFile xmlFile = XmlUtil.findNamespaceByLocation(baseFile, value);
            if (xmlFile != null) {
                return xmlFile;
            }
            int i = XmlUtil.getPrefixLength(value);
            if (i > 0) {
                return XmlUtil.findNamespaceByLocation(baseFile, value.substring(i));
            }
        }
        return null;
    }

    @Override
    public boolean isInternalReference() {
        for (ASTNode e = this.getFirstChildNode(); e != null; e = e.getTreeNext()) {
            XmlToken token;
            if (!(e.getElementType() instanceof IXmlLeafElementType) || (token = (XmlToken)SourceTreeToPsiMap.treeElementToPsi(e)).getTokenType() != XmlTokenType.XML_DOCTYPE_PUBLIC && token.getTokenType() != XmlTokenType.XML_DOCTYPE_SYSTEM) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.getNameElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlEntityDeclImpl", "getNavigationElement"));
        }
        return psiElement;
    }

    @Override
    public int getTextOffset() {
        PsiElement name = this.getNameElement();
        return name != null ? name.getTextOffset() : super.getTextOffset();
    }

    @Override
    public boolean canNavigate() {
        if (this.isPhysical()) {
            return super.canNavigate();
        }
        PsiNamedElement psiNamedElement = XmlUtil.findRealNamedElement(this);
        return psiNamedElement != null;
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (!this.isPhysical()) {
            ((Navigatable)((Object)XmlUtil.findRealNamedElement(this))).navigate(requestFocus);
            return;
        }
        super.navigate(requestFocus);
    }
}

