/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml.behavior;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.behavior.DefaultXmlPsiPolicy;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;

public class EncodeEachSymbolPolicy
extends DefaultXmlPsiPolicy {
    @Override
    public ASTNode encodeXmlTextContents(String displayText, PsiElement text) {
        String plainSection;
        int offset;
        if (!EncodeEachSymbolPolicy.toCode(displayText)) {
            return super.encodeXmlTextContents(displayText, text);
        }
        FileElement dummyParent = DummyHolderFactory.createHolder(text.getManager(), null, SharedImplUtil.findCharTableByTree(text.getNode())).getTreeElement();
        int sectionStartOffset = 0;
        for (offset = 0; offset < displayText.length(); ++offset) {
            if (!EncodeEachSymbolPolicy.toCode(displayText.charAt(offset))) continue;
            plainSection = displayText.substring(sectionStartOffset, offset);
            if (!plainSection.isEmpty()) {
                dummyParent.rawAddChildren((TreeElement)super.encodeXmlTextContents(plainSection, text));
            }
            dummyParent.rawAddChildren(EncodeEachSymbolPolicy.createCharEntity(displayText.charAt(offset), dummyParent.getCharTable()));
            sectionStartOffset = offset + 1;
        }
        plainSection = displayText.substring(sectionStartOffset, offset);
        if (!plainSection.isEmpty()) {
            dummyParent.rawAddChildren((TreeElement)super.encodeXmlTextContents(plainSection, text));
        }
        dummyParent.acceptTree(new GeneratedMarkerVisitor());
        return dummyParent.getFirstChildNode();
    }

    private static TreeElement createCharEntity(char ch, CharTable charTable) {
        switch (ch) {
            case '<': {
                return ASTFactory.leaf(XmlTokenType.XML_CHAR_ENTITY_REF, "&lt;");
            }
            case '\'': {
                return ASTFactory.leaf(XmlTokenType.XML_CHAR_ENTITY_REF, "&apos;");
            }
            case '\"': {
                return ASTFactory.leaf(XmlTokenType.XML_CHAR_ENTITY_REF, "&quot;");
            }
            case '>': {
                return ASTFactory.leaf(XmlTokenType.XML_CHAR_ENTITY_REF, "&gt;");
            }
            case '&': {
                return ASTFactory.leaf(XmlTokenType.XML_CHAR_ENTITY_REF, "&amp;");
            }
            case '\u00a0': {
                return ASTFactory.leaf(XmlTokenType.XML_CHAR_ENTITY_REF, "&nbsp;");
            }
        }
        String charEncoding = "&#" + ch + ";";
        return ASTFactory.leaf(XmlTokenType.XML_CHAR_ENTITY_REF, charTable.intern(charEncoding));
    }

    private static boolean toCode(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!EncodeEachSymbolPolicy.toCode(ch)) continue;
            return true;
        }
        return false;
    }

    private static boolean toCode(char ch) {
        return "<&>\u00a0'\"".indexOf(ch) >= 0;
    }
}

