/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.DumbAwareSearchParameters;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchRequestQuery;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.search.searches.ReferenceDescriptor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.MergeQuery;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UniqueResultsQuery;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReferencesSearch
extends ExtensibleQueryFactory<PsiReference, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create("com.intellij.methodReferencesSearch");
    public static final MethodReferencesSearch INSTANCE = new MethodReferencesSearch();

    private MethodReferencesSearch() {
    }

    public static Query<PsiReference> search(@NotNull PsiMethod method, SearchScope scope, boolean strictSignatureSearch) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/search/searches/MethodReferencesSearch", "search"));
        }
        return MethodReferencesSearch.search(new SearchParameters(method, scope, strictSignatureSearch));
    }

    public static void searchOptimized(PsiMethod method, SearchScope scope, boolean strictSignatureSearch, @NotNull SearchRequestCollector collector, Processor<PsiReference> processor) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/psi/search/searches/MethodReferencesSearch", "searchOptimized"));
        }
        MethodReferencesSearch.searchOptimized(method, scope, strictSignatureSearch, collector, false, (psiReference, collector1) -> processor.process((PsiReference)psiReference));
    }

    public static void searchOptimized(PsiMethod method, SearchScope scope, boolean strictSignatureSearch, SearchRequestCollector collector, boolean inReadAction, PairProcessor<PsiReference, SearchRequestCollector> processor) {
        SearchRequestCollector nested = new SearchRequestCollector(collector.getSearchSession());
        collector.searchQuery(new QuerySearchRequest(MethodReferencesSearch.search(new SearchParameters(method, scope, strictSignatureSearch, nested)), nested, inReadAction, processor));
    }

    public static Query<PsiReference> search(SearchParameters parameters) {
        Query<PsiReference> result = INSTANCE.createQuery(parameters);
        if (parameters.isSharedOptimizer) {
            return MethodReferencesSearch.uniqueResults(result);
        }
        SearchRequestCollector requests = parameters.getOptimizer();
        Project project = PsiUtilCore.getProjectInReadAction(parameters.getMethod());
        return MethodReferencesSearch.uniqueResults(new MergeQuery<PsiReference>(result, new SearchRequestQuery(project, requests)));
    }

    public static Query<PsiReference> search(PsiMethod method, boolean strictSignatureSearch) {
        return MethodReferencesSearch.search(method, GlobalSearchScope.allScope(PsiUtilCore.getProjectInReadAction(method)), strictSignatureSearch);
    }

    public static Query<PsiReference> search(PsiMethod method) {
        return MethodReferencesSearch.search(method, true);
    }

    private static UniqueResultsQuery<PsiReference, ReferenceDescriptor> uniqueResults(@NotNull Query<PsiReference> composite) {
        if (composite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "composite", "com/intellij/psi/search/searches/MethodReferencesSearch", "uniqueResults"));
        }
        return new UniqueResultsQuery<PsiReference, ReferenceDescriptor>(composite, ContainerUtil.canonicalStrategy(), ReferenceDescriptor.MAPPER);
    }

    public static class SearchParameters
    implements DumbAwareSearchParameters {
        private final PsiMethod myMethod;
        private final Project myProject;
        private final SearchScope myScope;
        private final boolean myStrictSignatureSearch;
        private final SearchRequestCollector myOptimizer;
        private final boolean isSharedOptimizer;

        public SearchParameters(@NotNull PsiMethod method, @NotNull SearchScope scope, boolean strictSignatureSearch, @Nullable SearchRequestCollector optimizer) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters", "<init>"));
            }
            this.myMethod = method;
            this.myScope = scope;
            this.myStrictSignatureSearch = strictSignatureSearch;
            this.isSharedOptimizer = optimizer != null;
            this.myOptimizer = optimizer != null ? optimizer : new SearchRequestCollector(new SearchSession());
            this.myProject = PsiUtilCore.getProjectInReadAction(method);
        }

        public SearchParameters(@NotNull PsiMethod method, @NotNull SearchScope scope, boolean strict) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters", "<init>"));
            }
            this(method, scope, strict, null);
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters", "getProject"));
            }
            return project;
        }

        @NotNull
        public PsiMethod getMethod() {
            PsiMethod psiMethod = this.myMethod;
            if (psiMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters", "getMethod"));
            }
            return psiMethod;
        }

        public boolean isStrictSignatureSearch() {
            return this.myStrictSignatureSearch;
        }

        public SearchRequestCollector getOptimizer() {
            return this.myOptimizer;
        }

        public SearchScope getScopeDeterminedByUser() {
            return this.myScope;
        }

        @Deprecated
        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.getScopeDeterminedByUser();
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters", "getScope"));
            }
            return searchScope;
        }

        @NotNull
        public SearchScope getEffectiveSearchScope() {
            SearchScope accessScope = PsiSearchHelper.SERVICE.getInstance(this.myMethod.getProject()).getUseScope(this.myMethod);
            SearchScope searchScope = this.myScope.intersectWith(accessScope);
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters", "getEffectiveSearchScope"));
            }
            return searchScope;
        }
    }
}

