/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;

public class FieldReturnValue
implements ReturnValue {
    private final PsiField myField;

    public FieldReturnValue(PsiField psiField) {
        this.myField = psiField;
    }

    @Override
    public boolean isEquivalent(ReturnValue other) {
        if (!(other instanceof FieldReturnValue)) {
            return false;
        }
        return this.myField == ((FieldReturnValue)other).myField;
    }

    public PsiField getField() {
        return this.myField;
    }

    @Override
    public PsiStatement createReplacement(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance(methodCallExpression.getProject()).getElementFactory();
        CodeStyleManager styleManager = CodeStyleManager.getInstance(methodCallExpression.getProject());
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)elementFactory.createStatementFromText("x = y();", null);
        expressionStatement = (PsiExpressionStatement)styleManager.reformat(expressionStatement);
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expressionStatement.getExpression();
        assignmentExpression.getLExpression().replace(elementFactory.createExpressionFromText(this.myField.getName(), this.myField));
        assignmentExpression.getRExpression().replace(methodCallExpression);
        return expressionStatement;
    }
}

