/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementsGroup;

public abstract class XmlElementsGroupBase
implements XmlElementsGroup {
    protected final XmlTag myTag;
    private final XmlElementsGroup myParent;
    private final XmlTag myRef;

    public XmlElementsGroupBase(XmlTag tag, XmlElementsGroup parent, XmlTag ref) {
        this.myTag = tag;
        this.myParent = parent;
        this.myRef = ref;
    }

    @Override
    public int getMinOccurs() {
        return XmlElementsGroupBase.getMinOccursImpl(this.myRef) * XmlElementsGroupBase.getMinOccursImpl(this.myTag);
    }

    private static int getMinOccursImpl(XmlTag tag) {
        if (tag == null) {
            return 1;
        }
        String value = tag.getAttributeValue("minOccurs");
        try {
            return value == null ? 1 : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @Override
    public int getMaxOccurs() {
        return XmlElementsGroupBase.getMaxOccursImpl(this.myRef) * XmlElementsGroupBase.getMaxOccursImpl(this.myTag);
    }

    private static int getMaxOccursImpl(XmlTag tag) {
        if (tag == null) {
            return 1;
        }
        String value = tag.getAttributeValue("maxOccurs");
        if (value == null) {
            return 1;
        }
        if ("unbounded".equals(value)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @Override
    public XmlElementsGroup getParentGroup() {
        return this.myParent;
    }
}

