/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticMethodOnlyUsedInOneClassInspectionBase
extends BaseInspection {
    public boolean ignoreTestClasses = false;
    public boolean ignoreAnonymousClasses = true;
    public boolean ignoreOnConflicts = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiNamedElement element = (PsiNamedElement)infos[0];
        String name = element.getName();
        if (infos.length > 1) {
            if (Boolean.TRUE.equals(infos[1])) {
                String string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.problem.descriptor.anonymous.extending", name);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspectionBase", "buildErrorString"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.problem.descriptor.anonymous.implementing", name);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.problem.descriptor", name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox(InspectionGadgetsBundle.message("static.method.only.used.in.one.class.ignore.test.option", new Object[0]), "ignoreTestClasses");
        panel.addCheckbox(InspectionGadgetsBundle.message("static.method.only.used.in.one.class.ignore.anonymous.option", new Object[0]), "ignoreAnonymousClasses");
        panel.addCheckbox(InspectionGadgetsBundle.message("static.method.only.used.in.one.class.ignore.on.conflicts", new Object[0]), "ignoreOnConflicts");
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticMethodOnlyUsedInOneClassVisitor();
    }

    private static boolean areReferenceTargetsAccessible(final PsiElement elementToCheck, final PsiElement place) {
        return PsiTreeUtil.processElements(elementToCheck, new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspectionBase$1", "execute"));
                }
                if (!(element instanceof PsiJavaCodeReferenceElement)) {
                    return true;
                }
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
                PsiElement target = referenceElement.resolve();
                if (target == null) {
                    return false;
                }
                if (PsiTreeUtil.isAncestor(elementToCheck, target, false)) {
                    return true;
                }
                return target instanceof PsiMember && PsiUtil.isAccessible((PsiMember)target, place, null);
            }
        });
    }

    private class StaticMethodOnlyUsedInOneClassVisitor
    extends BaseInspectionVisitor {
        private StaticMethodOnlyUsedInOneClassVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!method.hasModifierProperty("static")) {
                return;
            }
            if (method.hasModifierProperty("private")) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            UsageProcessor usageProcessor = new UsageProcessor();
            PsiClass usageClass = usageProcessor.getUsageClass(method);
            if (usageClass == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (usageClass.equals(containingClass)) {
                return;
            }
            if (StaticMethodOnlyUsedInOneClassInspectionBase.this.ignoreOnConflicts && (usageClass.findMethodsBySignature(method, true).length > 0 || !StaticMethodOnlyUsedInOneClassInspectionBase.areReferenceTargetsAccessible(method, usageClass))) {
                return;
            }
            if (StaticMethodOnlyUsedInOneClassInspectionBase.this.ignoreTestClasses && TestUtils.isInTestCode(usageClass)) {
                return;
            }
            if (usageClass instanceof PsiAnonymousClass) {
                if (StaticMethodOnlyUsedInOneClassInspectionBase.this.ignoreAnonymousClasses) {
                    return;
                }
                if (PsiTreeUtil.isAncestor(containingClass, usageClass, true)) {
                    return;
                }
                PsiClass[] interfaces = usageClass.getInterfaces();
                if (interfaces.length == 1) {
                    PsiClass superClass = interfaces[0];
                    this.registerMethodError(method, superClass, Boolean.FALSE);
                } else {
                    PsiClass superClass = usageClass.getSuperClass();
                    if (superClass == null) {
                        return;
                    }
                    this.registerMethodError(method, superClass, Boolean.TRUE);
                }
            } else {
                this.registerMethodError(method, usageClass);
            }
        }
    }

    private static class UsageProcessor
    implements Processor<PsiReference> {
        private final AtomicReference<PsiClass> foundClass = new AtomicReference();

        private UsageProcessor() {
        }

        @Override
        public boolean process(PsiReference reference) {
            ProgressManager.checkCanceled();
            PsiElement element = reference.getElement();
            PsiClass usageClass = ClassUtils.getContainingClass(element);
            if (usageClass == null) {
                return true;
            }
            if (this.foundClass.compareAndSet(null, usageClass)) {
                return true;
            }
            PsiClass aClass = this.foundClass.get();
            PsiManager manager = usageClass.getManager();
            return manager.areElementsEquivalent(aClass, usageClass);
        }

        @Nullable
        public PsiClass getUsageClass(PsiMethod method) {
            GlobalSearchScope scope;
            String name;
            ProgressManager progressManager = ProgressManager.getInstance();
            PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance(method.getProject());
            if (searchHelper.isCheapEnoughToSearch(name = method.getName(), scope = GlobalSearchScope.projectScope(method.getProject()), null, progressManager.getProgressIndicator()) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                return null;
            }
            progressManager.runProcess(() -> {
                Query<PsiReference> query = MethodReferencesSearch.search(method);
                if (!query.forEach(this)) {
                    this.foundClass.set(null);
                }
            }, null);
            return this.foundClass.get();
        }
    }
}

