/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignmentToDateFieldFromParameterInspection
extends BaseInspection {
    public boolean ignorePrivateMethods = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.to.date.calendar.field.from.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentToDateFieldFromParameterInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String type = (String)infos[0];
        PsiExpression rhs = (PsiExpression)infos[1];
        String string = InspectionGadgetsBundle.message("assignment.to.date.calendar.field.from.parameter.problem.descriptor", type, rhs.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentToDateFieldFromParameterInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("assignment.collection.array.field.option", new Object[0]), this, "ignorePrivateMethods");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToDateFieldFromParameterVisitor();
    }

    private class AssignmentToDateFieldFromParameterVisitor
    extends BaseInspectionVisitor {
        private AssignmentToDateFieldFromParameterVisitor() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            PsiMethod containingMethod;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/assignment/AssignmentToDateFieldFromParameterInspection$AssignmentToDateFieldFromParameterVisitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!JavaTokenType.EQ.equals(tokenType)) {
                return;
            }
            PsiExpression lhs = expression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            String type = TypeUtils.expressionHasTypeOrSubtype(lhs, "java.util.Date", "java.util.Calendar");
            if (type == null) {
                return;
            }
            PsiExpression rhs = expression.getRExpression();
            if (!(rhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement lhsReferent = ((PsiReference)((Object)lhs)).resolve();
            if (!(lhsReferent instanceof PsiField)) {
                return;
            }
            PsiElement rhsReferent = ((PsiReference)((Object)rhs)).resolve();
            if (!(rhsReferent instanceof PsiParameter)) {
                return;
            }
            if (!(rhsReferent.getParent() instanceof PsiParameterList)) {
                return;
            }
            if (AssignmentToDateFieldFromParameterInspection.this.ignorePrivateMethods && ((containingMethod = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class)) == null || containingMethod.hasModifierProperty("private"))) {
                return;
            }
            this.registerError((PsiElement)lhs, type, rhs);
        }
    }
}

