/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ComparatorMethodParameterNotUsedInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("comparator.method.parameter.not.used.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ComparatorMethodParameterNotUsedInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("comparator.method.parameter.not.used.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ComparatorMethodParameterNotUsedInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CompareMethodDoesNotUseParameterVisitor();
    }

    private static class CompareMethodDoesNotUseParameterVisitor
    extends BaseInspectionVisitor {
        private CompareMethodDoesNotUseParameterVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!MethodUtils.isComparatorCompare(method) || ControlFlowUtils.methodAlwaysThrowsException(method)) {
                return;
            }
            this.checkParameterList(method.getParameterList(), method);
        }

        @Override
        public void visitLambdaExpression(PsiLambdaExpression expression) {
            super.visitLambdaExpression(expression);
            PsiClass functionalInterface = PsiUtil.resolveClassInType(expression.getFunctionalInterfaceType());
            if (functionalInterface == null || !"java.util.Comparator".equals(functionalInterface.getQualifiedName()) || ControlFlowUtils.lambdaExpressionAlwaysThrowsException(expression)) {
                return;
            }
            this.checkParameterList(expression.getParameterList(), expression);
        }

        private void checkParameterList(PsiParameterList parameterList, PsiElement context) {
            ParameterAccessVisitor visitor = new ParameterAccessVisitor(parameterList.getParameters());
            context.accept(visitor);
            for (PsiParameter unusedParameter : visitor.getUnusedParameters()) {
                this.registerVariableError(unusedParameter, new Object[0]);
            }
        }

        private static class ParameterAccessVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final Set<PsiParameter> parameters;

            private ParameterAccessVisitor(@NotNull PsiParameter[] parameters) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/siyeh/ig/bugs/ComparatorMethodParameterNotUsedInspection$CompareMethodDoesNotUseParameterVisitor$ParameterAccessVisitor", "<init>"));
                }
                this.parameters = new HashSet<PsiParameter>(Arrays.asList(parameters));
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                if (this.parameters.isEmpty()) {
                    return;
                }
                if (expression.getQualifierExpression() != null) {
                    return;
                }
                PsiElement target = expression.resolve();
                if (!(target instanceof PsiParameter)) {
                    return;
                }
                PsiParameter parameter = (PsiParameter)target;
                this.parameters.remove(parameter);
            }

            private Collection<PsiParameter> getUnusedParameters() {
                return Collections.unmodifiableSet(this.parameters);
            }
        }
    }
}

