/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class CovariantCompareToInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("covariant.compareto.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/CovariantCompareToInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("covariant.compareto.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/CovariantCompareToInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CovariantCompareToVisitor();
    }

    private static class CovariantCompareToVisitor
    extends BaseInspectionVisitor {
        private CovariantCompareToVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            PsiSubstitutor superSubstitutor;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/bugs/CovariantCompareToInspection$CovariantCompareToVisitor", "visitMethod"));
            }
            String name = method.getName();
            if (!"compareTo".equals(name)) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiType paramType = parameters[0].getType();
            if (TypeUtils.isJavaLangObject(paramType)) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            PsiMethod[] methods = aClass.findMethodsByName("compareTo", false);
            Project project = method.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
            GlobalSearchScope scope = method.getResolveScope();
            PsiClass comparableClass = psiFacade.findClass("java.lang.Comparable", scope);
            PsiType substitutedTypeParam = null;
            if (comparableClass != null && comparableClass.getTypeParameters().length == 1 && (superSubstitutor = TypeConversionUtil.getClassSubstitutor(comparableClass, aClass, PsiSubstitutor.EMPTY)) != null) {
                substitutedTypeParam = superSubstitutor.substitute(comparableClass.getTypeParameters()[0]);
            }
            for (PsiMethod compareToMethod : methods) {
                if (!CovariantCompareToVisitor.isNonVariantCompareTo(compareToMethod, substitutedTypeParam)) continue;
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static boolean isNonVariantCompareTo(PsiMethod method, PsiType substitutedTypeParam) {
            PsiClassType objectType = TypeUtils.getObjectType(method);
            if (MethodUtils.methodMatches(method, null, (PsiType)PsiType.INT, "compareTo", objectType)) {
                return true;
            }
            if (substitutedTypeParam == null) {
                return false;
            }
            return MethodUtils.methodMatches(method, null, (PsiType)PsiType.INT, "compareTo", substitutedTypeParam);
        }
    }
}

