/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitArrayToStringInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("implicit.array.to.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ImplicitArrayToStringInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (((Boolean)infos[1]).booleanValue()) {
            String string = InspectionGadgetsBundle.message("explicit.array.to.string.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ImplicitArrayToStringInspection", "buildErrorString"));
            }
            return string;
        }
        if (infos[0] instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("implicit.array.to.string.method.call.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ImplicitArrayToStringInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("implicit.array.to.string.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ImplicitArrayToStringInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiType componentType;
        PsiExpression expression = (PsiExpression)infos[0];
        boolean removeToString = (Boolean)infos[1];
        PsiArrayType type = (PsiArrayType)expression.getType();
        if (type != null && (componentType = type.getComponentType()) instanceof PsiArrayType) {
            return new ImplicitArrayToStringFix(true, removeToString);
        }
        return new ImplicitArrayToStringFix(false, removeToString);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitArrayToStringVisitor();
    }

    private static class ImplicitArrayToStringVisitor
    extends BaseInspectionVisitor {
        private ImplicitArrayToStringVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall(expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression, Boolean.FALSE);
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall(expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression, Boolean.FALSE);
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (ImplicitArrayToStringVisitor.isExplicitArrayToStringCall(expression)) {
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                this.registerMethodCallError(expression, qualifier, Boolean.TRUE);
                return;
            }
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall(expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression, Boolean.FALSE);
        }

        private static boolean isExplicitArrayToStringCall(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toString".equals(methodName)) {
                return false;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 0) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType type = qualifier.getType();
            return type instanceof PsiArrayType;
        }

        private static boolean isImplicitArrayToStringCall(PsiExpression expression) {
            PsiType type = expression.getType();
            if (!(type instanceof PsiArrayType)) {
                return false;
            }
            if (ExpressionUtils.isStringConcatenationOperand(expression)) {
                return true;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiExpressionList) {
                String qualifiedName;
                PsiExpressionList expressionList = (PsiExpressionList)parent;
                PsiArrayType arrayType = (PsiArrayType)type;
                PsiType componentType = arrayType.getComponentType();
                if (componentType.equals(PsiType.CHAR)) {
                    return false;
                }
                PsiElement grandParent = expressionList.getParent();
                if (!(grandParent instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiExpression[] arguments = expressionList.getExpressions();
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null) {
                    return false;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return false;
                }
                if ("append".equals(methodName)) {
                    if (arguments.length != 1) {
                        return false;
                    }
                    return InheritanceUtil.isInheritor(containingClass, "java.lang.AbstractStringBuilder");
                }
                if ("valueOf".equals(methodName)) {
                    if (arguments.length != 1) {
                        return false;
                    }
                    String qualifiedName2 = containingClass.getQualifiedName();
                    return "java.lang.String".equals(qualifiedName2);
                }
                if (!"print".equals(methodName) && !"println".equals(methodName)) {
                    if (!"printf".equals(methodName) && !"format".equals(methodName)) {
                        return false;
                    }
                    if (arguments.length < 1) {
                        return false;
                    }
                    PsiParameterList parameterList = method.getParameterList();
                    PsiParameter[] parameters = parameterList.getParameters();
                    PsiParameter parameter = parameters[0];
                    PsiType firstParameterType = parameter.getType();
                    if (firstParameterType.equalsToText("java.util.Locale") ? arguments.length < 4 : arguments.length < 3) {
                        return false;
                    }
                }
                if ("java.util.Formatter".equals(qualifiedName = containingClass.getQualifiedName()) || "java.lang.String".equals(qualifiedName)) {
                    return true;
                }
                if (InheritanceUtil.isInheritor(containingClass, "java.io.PrintStream")) {
                    return true;
                }
                if (InheritanceUtil.isInheritor(containingClass, "java.io.PrintWriter")) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class ImplicitArrayToStringFix
    extends InspectionGadgetsFix {
        private final boolean deepString;
        private final boolean removeToString;

        ImplicitArrayToStringFix(boolean deepString, boolean removeToString) {
            this.deepString = deepString;
            this.removeToString = removeToString;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Make Array.toString() implicit" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ImplicitArrayToStringInspection$ImplicitArrayToStringFix", "getFamilyName"));
            }
            return "Make Array.toString() implicit";
        }

        @Override
        @NotNull
        public String getName() {
            String expressionText = this.deepString ? "java.util.Arrays.deepToString()" : "java.util.Arrays.toString()";
            String string = InspectionGadgetsBundle.message("implicit.array.to.string.quickfix", expressionText);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ImplicitArrayToStringInspection$ImplicitArrayToStringFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethodCallExpression methodCallExpression;
            PsiReferenceExpression methodExpression;
            PsiElement grandParent;
            String expressionText;
            PsiElement element = descriptor.getPsiElement();
            PsiExpression expression = element instanceof PsiExpression ? (PsiExpression)element : (PsiExpression)element.getParent().getParent();
            if (this.removeToString) {
                PsiMethodCallExpression methodCallExpression2 = (PsiMethodCallExpression)expression;
                PsiReferenceExpression methodExpression2 = methodCallExpression2.getMethodExpression();
                PsiExpression qualifier = methodExpression2.getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                expressionText = qualifier.getText();
            } else {
                expressionText = expression.getText();
            }
            String newExpressionText = this.deepString ? "java.util.Arrays.deepToString(" + expressionText + ')' : "java.util.Arrays.toString(" + expressionText + ')';
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiExpressionList && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression && "valueOf".equals((methodExpression = (methodCallExpression = (PsiMethodCallExpression)grandParent).getMethodExpression()).getReferenceName())) {
                PsiReplacementUtil.replaceExpressionAndShorten(methodCallExpression, newExpressionText);
                return;
            }
            PsiReplacementUtil.replaceExpressionAndShorten(expression, newExpressionText);
        }
    }
}

