/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class MultipleTopLevelClassesInFileInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("multiple.top.level.classes.in.file.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/MultipleTopLevelClassesInFileInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("multiple.top.level.classes.in.file.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/MultipleTopLevelClassesInFileInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MultipleTopLevelClassesInFileVisitor();
    }

    private static class MultipleTopLevelClassesInFileVisitor
    extends BaseInspectionVisitor {
        private MultipleTopLevelClassesInFileVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            PsiElement[] children;
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/MultipleTopLevelClassesInFileInspectionBase$MultipleTopLevelClassesInFileVisitor", "visitClass"));
            }
            if (!(aClass.getParent() instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)aClass.getParent();
            if (file == null) {
                return;
            }
            int numClasses = 0;
            for (PsiElement child : children = file.getChildren()) {
                if (!(child instanceof PsiClass)) continue;
                ++numClasses;
            }
            if (numClasses <= 1) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

