/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class ProtectedMemberInFinalClassInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("protected.member.in.final.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("protected.member.in.final.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ProtectedMemberInFinalClassVisitor();
    }

    private static class ProtectedMemberInFinalClassVisitor
    extends BaseInspectionVisitor {
        private ProtectedMemberInFinalClassVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspectionBase$ProtectedMemberInFinalClassVisitor", "visitMethod"));
            }
            if (!method.hasModifierProperty("protected")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !containingClass.hasModifierProperty("final")) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            this.registerModifierError("protected", method, "protected");
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspectionBase$ProtectedMemberInFinalClassVisitor", "visitField"));
            }
            if (!field.hasModifierProperty("protected")) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || !containingClass.hasModifierProperty("final")) {
                return;
            }
            this.registerModifierError("protected", field, "protected");
        }
    }
}

